/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.Handlers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Handlers.Handler(getInstFrom=Handlers.Handler.Inst.METHOD)
public class Scheduler {
    private final List<Task> tasks = new ArrayList<Task>();

    public void schedule(int delay, Runnable task) {
        this.schedule(delay, task, Side.SERVER);
    }

    public void schedule(int delay, Runnable task, Side side) {
        this.tasks.add(new Task(delay, task, side));
    }

    public static Scheduler instance() {
        return EnderCore.proxy.getScheduler();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(Side.SERVER);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(Side.CLIENT);
        }
    }

    private void runTasks(Side side) {
        Iterator<Task> iter = this.tasks.iterator();
        while (iter.hasNext()) {
            Task next = iter.next();
            if (next.side != side || !next.run()) continue;
            iter.remove();
        }
    }

    private static final class Task {
        private int delay;
        private Runnable toRun;
        private Side side;

        private Task(int delay, Runnable toRun, Side side) {
            this.delay = delay;
            this.toRun = toRun;
            this.side = side;
        }

        private boolean run() {
            if (this.delay <= 0) {
                this.toRun.run();
                return true;
            }
            --this.delay;
            return false;
        }
    }
}

