/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.tool.ToolUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderLiquidConduit
extends AbstractLiquidConduit {
    public static final String ICON_KEY = "enderio:blocks/liquidConduitEnder";
    public static final String ICON_CORE_KEY = "enderio:blocks/liquidConduitCoreEnder";
    public static final String ICON_IN_OUT_KEY = "enderio:blocks/liquidConduitAdvancedInOut";
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    private EnderLiquidConduitNetwork network;
    private int ticksSinceFailedExtract;
    private final EnumMap<EnumFacing, FluidFilter> outputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, FluidFilter> inputFilters = new EnumMap(EnumFacing.class);

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put(EnderLiquidConduit.ICON_KEY, register.func_174942_a(new ResourceLocation(EnderLiquidConduit.ICON_KEY)));
                ICONS.put(EnderLiquidConduit.ICON_CORE_KEY, register.func_174942_a(new ResourceLocation(EnderLiquidConduit.ICON_CORE_KEY)));
                ICONS.put(EnderLiquidConduit.ICON_IN_OUT_KEY, register.func_174942_a(new ResourceLocation(EnderLiquidConduit.ICON_IN_OUT_KEY)));
            }
        });
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemLiquidConduit, 1, 2);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                EnumFacing connDir = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir == null || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!(n instanceof EnderLiquidConduit)) {
                        return false;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public FluidFilter getFilter(EnumFacing dir, boolean isInput) {
        if (isInput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setFilter(EnumFacing dir, FluidFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof EnderLiquidConduitNetwork)) {
            return false;
        }
        this.network = (EnderLiquidConduitNetwork)network;
        for (EnumFacing dir : this.externalConnections) {
            this.network.connectionChanged(this, dir);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return ICONS.get(ICON_CORE_KEY);
        }
        return ICONS.get(ICON_KEY);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInputMode() {
        return AdvancedLiquidConduit.ICONS.get("enderio:blocks/liquidConduitAdvancedInput");
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForOutputMode() {
        return AdvancedLiquidConduit.ICONS.get("enderio:blocks/liquidConduitAdvancedOutput");
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode() {
        return ICONS.get(ICON_IN_OUT_KEY);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        return con instanceof EnderLiquidConduit;
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnections(dir);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshConnections(dir);
    }

    private void refreshConnections(EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Override
    public void externalConnectionAdded(EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.network == null || !this.getConnectionMode(from).acceptsInput()) {
            return 0;
        }
        return this.network.fillFrom(this, from, resource, doFill);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.network == null) {
            return new FluidTankInfo[0];
        }
        return this.network.getTankInfo(this, from);
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        super.readTypeSettings(dir, dataRoot);
        if (dataRoot.func_74764_b("outputFilters")) {
            FluidFilter out = new FluidFilter();
            out.readFromNBT(dataRoot.func_74775_l("outputFilters"));
            this.outputFilters.put(dir, out);
        }
        if (dataRoot.func_74764_b("inputFilters")) {
            FluidFilter in = new FluidFilter();
            in.readFromNBT(dataRoot.func_74775_l("inputFilters"));
            this.inputFilters.put(dir, in);
        }
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        FluidFilter in;
        super.writeTypeSettingsToNbt(dir, dataRoot);
        FluidFilter out = this.outputFilters.get(dir);
        if (out != null) {
            NBTTagCompound outTag = new NBTTagCompound();
            out.writeToNBT(outTag);
            dataRoot.func_74782_a("outputFilters", (NBTBase)outTag);
        }
        if ((in = this.inputFilters.get(dir)) != null) {
            NBTTagCompound inTag = new NBTTagCompound();
            in.writeToNBT(inTag);
            dataRoot.func_74782_a("inputFilters", (NBTBase)inTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        FluidFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, FluidFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, FluidFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || (f = entry.getValue()) == null || f.isDefault()) continue;
            itemRoot = new NBTTagCompound();
            f.writeToNBT(itemRoot);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            FluidFilter f;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                f = new FluidFilter();
                f.readFromNBT(filterTag);
                if (!f.isEmpty()) {
                    this.inputFilters.put(dir, f);
                }
            }
            if (!nbtRoot.func_74764_b(key = "outFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
            f = new FluidFilter();
            f.readFromNBT(filterTag);
            if (f.isEmpty()) continue;
            this.outputFilters.put(dir, f);
        }
    }
}

