/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class LiquidConduitRenderer
extends DefaultConduitRenderer
implements IResourceManagerReloadListener {
    private float downRatio;
    private float flatRatio;
    private float upRatio;
    private static Map<CollidableComponent, Map<Fluid, List<CachableRenderStatement>>> cache = new WeakHashMap<CollidableComponent, Map<Fluid, List<CachableRenderStatement>>>();

    private LiquidConduitRenderer() {
    }

    public static LiquidConduitRenderer create() {
        LiquidConduitRenderer result = new LiquidConduitRenderer();
        RenderUtil.registerReloadListener((IResourceManagerReloadListener)result);
        return result;
    }

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof LiquidConduit;
    }

    @Override
    protected void addTransmissionQuads(TextureAtlasSprite tex, IConduit conduit, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
    }

    @Override
    protected void renderConduitDynamic(TextureAtlasSprite tex, IConduit conduit, CollidableComponent component, float brightness) {
        LiquidConduit lc;
        FluidStack fluid;
        if (this.isNSEWUD(component.dir) && (fluid = (lc = (LiquidConduit)conduit).getFluidType()) != null) {
            LiquidConduitRenderer.renderFluidOutline(component, fluid);
        }
    }

    @Override
    public void renderDynamicEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        this.calculateRatios((LiquidConduit)conduit);
        super.renderDynamicEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight);
    }

    @Override
    protected void renderTransmissionDynamic(IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum) {
        if (((LiquidConduit)conduit).getTank().getFilledRatio() <= 0.0f) {
            return;
        }
        if (this.isNSEWUD(component.dir)) {
            BoundingBox[] cubes;
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawDynamicSection(cube, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
            }
        } else {
            this.drawDynamicSection(component.bound, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
        }
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid) {
        LiquidConduitRenderer.renderFluidOutline(component, fluid, 1.0, 0.8125f);
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid, double scaleFactor, float outlineWidth) {
        for (CachableRenderStatement elem : LiquidConduitRenderer.computeFluidOutlineToCache(component, fluid.getFluid(), scaleFactor, outlineWidth)) {
            elem.execute();
        }
    }

    public static List<CachableRenderStatement> computeFluidOutlineToCache(CollidableComponent component, Fluid fluid, double scaleFactor, float outlineWidth) {
        BoundingBox bbb;
        List<CachableRenderStatement> data;
        Map<Fluid, List<CachableRenderStatement>> cache0 = cache.get(component);
        if (cache0 == null) {
            cache0 = new HashMap<Fluid, List<CachableRenderStatement>>();
            cache.put(component, cache0);
        }
        if ((data = cache0.get(fluid)) != null) {
            return data;
        }
        data = new ArrayList<CachableRenderStatement>();
        cache0.put(fluid, data);
        TextureAtlasSprite texture = RenderUtil.getStillTexture((Fluid)fluid);
        if (texture == null) {
            return data;
        }
        if (scaleFactor == 1.0) {
            bbb = component.bound;
        } else {
            double xScale = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0 : scaleFactor;
            double yScale = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0 : scaleFactor;
            double zScale = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0 : scaleFactor;
            bbb = component.bound.scale(xScale, yScale, zScale);
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == component.dir || face == component.dir.func_176734_d()) continue;
            Vector3d offset = ForgeDirectionOffsets.offsetScaled((EnumFacing)face, (double)-0.005);
            Vector2f uv = new Vector2f();
            List edges = RenderUtil.getEdgesForFace((EnumFacing)face);
            for (EnumFacing edge : edges) {
                if (edge == component.dir || edge == component.dir.func_176734_d()) continue;
                float xLen = 1.0f - (float)Math.abs(edge.func_82601_c()) * outlineWidth;
                float yLen = 1.0f - (float)Math.abs(edge.func_96559_d()) * outlineWidth;
                float zLen = 1.0f - (float)Math.abs(edge.func_82599_e()) * outlineWidth;
                BoundingBox bb = bbb.scale(xLen, yLen, zLen);
                List corners = bb.getCornersForFace(face);
                for (Vector3f unitCorn : corners) {
                    Vector3d corner = new Vector3d(unitCorn);
                    corner.add(offset);
                    corner.x += (double)((float)((double)edge.func_82601_c() * 0.5 * (double)bbb.sizeX()) - Math.signum(edge.func_82601_c()) * xLen / 2.0f * bbb.sizeX() * 2.0f);
                    corner.y += (double)((float)((double)edge.func_96559_d() * 0.5 * (double)bbb.sizeY()) - Math.signum(edge.func_96559_d()) * yLen / 2.0f * bbb.sizeY() * 2.0f);
                    corner.z += (double)((float)((double)edge.func_82599_e() * 0.5 * (double)bbb.sizeZ()) - Math.signum(edge.func_82599_e()) * zLen / 2.0f * bbb.sizeZ() * 2.0f);
                    RenderUtil.getUvForCorner((Vector2f)uv, (Vector3d)corner, (int)0, (int)0, (int)0, (EnumFacing)face, (TextureAtlasSprite)texture);
                    data.add(new CachableRenderStatement.AddVertexWithUV(corner.x, corner.y, corner.z, uv.x, uv.y));
                }
            }
        }
        return data;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected void setVerticesForTransmission(BoundingBox bound, EnumFacing id) {
        float yScale = this.getRatioForConnection(id);
        float scale = 0.7f;
        float xs = id.func_82601_c() == 0 ? scale : 1.0f;
        float ys = id.func_96559_d() == 0 ? Math.min(yScale, scale) : yScale;
        float zs = id.func_82599_e() == 0 ? scale : 1.0f;
        float sizeY = bound.sizeY();
        bound = bound.scale(xs, ys, zs);
        float transY = (bound.sizeY() - sizeY) / 2.0f;
        Vector3d translation = new Vector3d(0.0, (double)transY + 0.025, 0.0);
        this.setupVertices(bound.translate(translation));
    }

    private void calculateRatios(LiquidConduit conduit) {
        ConduitTank tank = conduit.getTank();
        int totalAmount = tank.getFluidAmount();
        int upCapacity = 0;
        if (conduit.containsConduitConnection(EnumFacing.UP) || conduit.containsExternalConnection(EnumFacing.UP)) {
            upCapacity = 250;
        }
        int downCapacity = 0;
        if (conduit.containsConduitConnection(EnumFacing.DOWN) || conduit.containsExternalConnection(EnumFacing.DOWN)) {
            downCapacity = 250;
        }
        int flatCapacity = tank.getCapacity() - upCapacity - downCapacity;
        int usedCapacity = 0;
        if (downCapacity > 0) {
            int inDown = Math.min(totalAmount, downCapacity);
            usedCapacity += inDown;
            this.downRatio = (float)inDown / (float)downCapacity;
        }
        if (flatCapacity > 0 && usedCapacity < totalAmount) {
            int inFlat = Math.min(flatCapacity, totalAmount - usedCapacity);
            usedCapacity += inFlat;
            this.flatRatio = (float)inFlat / (float)flatCapacity;
        } else {
            this.flatRatio = 0.0f;
        }
        if (upCapacity > 0 && usedCapacity < totalAmount) {
            int inUp = Math.min(upCapacity, totalAmount - usedCapacity);
            this.upRatio = (float)inUp / (float)upCapacity;
        } else {
            this.upRatio = 0.0f;
        }
    }

    private float getRatioForConnection(EnumFacing id) {
        if (id == EnumFacing.UP) {
            return this.upRatio;
        }
        if (id == EnumFacing.DOWN) {
            return this.downRatio;
        }
        return this.flatRatio;
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        cache.clear();
    }

    private static interface CachableRenderStatement {
        public void execute();

        public static class AddVertexWithUV
        implements CachableRenderStatement {
            private final double x;
            private final double y;
            private final double z;
            private final double u;
            private final double v;

            private AddVertexWithUV(double x, double y, double z, double u, double v) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.u = u;
                this.v = v;
            }

            @Override
            public void execute() {
                Tessellator.func_178181_a().func_178180_c().func_181662_b(this.x, this.y, this.z).func_181673_a(this.u, this.v).func_181675_d();
            }
        }
    }
}

