/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Sets;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    private final Set<Signal> signals = new HashSet<Signal>();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class, IRedstoneConduit.class);
    }

    @Override
    public void init(IConduitBundle tile, Collection<IRedstoneConduit> connections, World world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignals();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
        }
        ArrayList<Signal> copy = new ArrayList<Signal>(this.signals);
        this.signals.clear();
        for (Signal s : copy) {
            this.notifyNeigborsOfSignalUpdate(s);
        }
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(IRedstoneConduit con) {
        this.updatingNetwork = true;
        super.addConduit(con);
        Set<Signal> newInputs = con.getNetworkInputs();
        this.signals.addAll(newInputs);
        for (Signal signal : newInputs) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
        for (Signal signal : this.signals) {
            this.notifyConduitNeighbours(con, signal);
        }
        this.updatingNetwork = false;
    }

    public Set<Signal> getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return Collections.emptySet();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    public void addSignals(Set<Signal> newSignals) {
        for (Signal signal : newSignals) {
            this.addSignal(signal);
        }
    }

    public void addSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.add(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void removeSignals(Set<Signal> remove) {
        for (Signal signal : remove) {
            this.removeSignal(signal);
        }
    }

    public void removeSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.remove(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void replaceSignal(Signal oldSig, Signal newSig) {
        this.updatingNetwork = true;
        this.signals.remove(oldSig);
        this.signals.add(newSig);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(newSig);
        this.updatingNetwork = false;
    }

    @Override
    public void notifyNetworkOfUpdate() {
        block0: for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
            for (Signal s : this.getSignals()) {
                if (s.strength <= 0) continue;
                con.setActive(true);
                continue block0;
            }
        }
        super.notifyNetworkOfUpdate();
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<").append(te.func_174877_v().func_177958_n()).append(",").append(te.func_174877_v().func_177956_o()).append(",").append(te.func_174877_v().func_177952_p()).append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignals() {
        for (Signal signal : this.signals) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
    }

    public void notifyNeigborsOfSignalUpdate(Signal signal) {
        ArrayList conduitsCopy = new ArrayList(this.conduits);
        for (IRedstoneConduit con : conduitsCopy) {
            this.notifyConduitNeighbours(con, signal);
        }
    }

    private void notifyConduitNeighbours(IRedstoneConduit con, Signal signal) {
        if (con.getBundle() == null) {
            System.out.println("RedstoneConduitNetwork.notifyNeigborsOfSignalUpdate: NULL BUNDLE!!!!");
            return;
        }
        TileEntity te = con.getBundle().getEntity();
        World worldObj = te.func_145831_w();
        BlockCoord bc1 = new BlockCoord(te);
        if (!worldObj.func_175667_e(te.func_174877_v())) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockCoord bc2 = bc1.getLocation(dir);
            if (!worldObj.func_175667_e(bc2.getBlockPos())) continue;
            worldObj.func_175685_c(bc2.getBlockPos(), (Block)EnderIO.blockConduitBundle);
            if (signal == null || !bc2.getBlock((IBlockAccess)worldObj).func_149721_r()) continue;
            for (EnumFacing dir2 : EnumFacing.field_82609_l) {
                BlockCoord bc3 = bc2.getLocation(dir2);
                if (bc3.equals((Object)bc1) || !worldObj.func_175667_e(bc3.getBlockPos())) continue;
                worldObj.func_175685_c(bc3.getBlockPos(), (Block)EnderIO.blockConduitBundle);
            }
        }
    }

    public void afterChunkUnload(List<IRedstoneConduit> conduits, Set<Signal> oldSignals) {
        World world = null;
        for (IRedstoneConduit c : conduits) {
            BlockCoord loc;
            if (world == null) {
                world = c.getBundle().getBundleWorldObj();
            }
            if (!world.func_175667_e((loc = c.getLocation()).getBlockPos())) continue;
            this.conduits.add(c);
            c.setNetwork(this);
        }
        HashSet valid = Sets.newHashSet();
        for (Signal s : oldSignals) {
            if (!world.func_175667_e(new BlockPos(s.x, s.y, s.z))) continue;
            valid.add(s);
        }
        this.addSignals(valid);
    }
}

