/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.util.ClientUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemEnderFood
extends ItemFood
implements IResourceTooltipProvider,
IHaveRenderers {
    @SideOnly(value=Side.CLIENT)
    private SpecialFont fr;

    public static ItemEnderFood create() {
        ItemEnderFood ret = new ItemEnderFood();
        GameRegistry.registerItem((Item)ret, (String)ModObject.itemEnderFood.getUnlocalisedName());
        return ret;
    }

    public ItemEnderFood() {
        super(0, false);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnderFood f : EnderFood.VALUES) {
            list.add(f.getStack());
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "enderio." + EnderFood.get((ItemStack)itemStack).unlocalisedName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        List<ResourceLocation> names = EnderFood.resources();
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])names.toArray(new ResourceLocation[names.size()]));
        for (EnderFood c : EnderFood.values()) {
            ClientUtil.regRenderer((Item)this, c.ordinal(), c.unlocalisedName);
        }
    }

    public int func_150905_g(ItemStack stack) {
        return EnderFood.get((ItemStack)stack).hunger;
    }

    public float func_150906_h(ItemStack stack) {
        return EnderFood.get((ItemStack)stack).saturation;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        if (this.fr == null) {
            this.fr = new SpecialFont(Minecraft.func_71410_x().field_71466_p);
        }
        return this.fr;
    }

    public static enum EnderFood {
        ENDERIOS("itemEnderios", 10, 0.8f);

        public final String unlocalisedName;
        public final int hunger;
        public final float saturation;
        public static final EnderFood[] VALUES;

        public static List<ResourceLocation> resources() {
            ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(EnderFood.values().length);
            for (EnderFood c : EnderFood.values()) {
                res.add(new ResourceLocation("EnderIO", c.unlocalisedName));
            }
            return res;
        }

        private EnderFood(String name, int hunger, float saturation) {
            this.unlocalisedName = name;
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int size) {
            return new ItemStack((Item)EnderIO.itemEnderFood, size, this.ordinal());
        }

        public static EnderFood get(ItemStack stack) {
            return VALUES[stack.func_77952_i() % VALUES.length];
        }

        static {
            VALUES = EnderFood.values();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class SpecialFont
    extends FontRenderer {
        private FontRenderer wrapped;
        private ItemStack stack;
        private int inARow;

        public SpecialFont(FontRenderer wrapped) {
            super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
            this.stack = EnderFood.ENDERIOS.getStack();
            this.inARow = 0;
            this.wrapped = wrapped;
        }

        public int func_175065_a(String string, float x, float y, int color, boolean dropShadow) {
            boolean pop = false;
            if (this.isSmallText(string)) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslated((double)x, (double)y, (double)0.0);
                GL11.glTranslated((double)0.0, (double)(-this.field_78288_b * this.inARow + this.field_78288_b), (double)0.0);
                ++this.inARow;
                pop = true;
            } else {
                this.inARow = 0;
            }
            int ret = this.wrapped.func_175065_a(string, x, y, color, dropShadow);
            if (pop) {
                GL11.glPopMatrix();
            }
            return ret;
        }

        public int func_78256_a(String p_78256_1_) {
            int ret = this.wrapped.func_78256_a(p_78256_1_);
            if (this.isSmallText(p_78256_1_)) {
                ret /= 2;
            }
            return ret;
        }

        private boolean isSmallText(String string) {
            ArrayList lines = Lists.newArrayList();
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)lines, (String)ItemEnderFood.this.getUnlocalizedNameForTooltip(this.stack));
            return lines.contains(EnumChatFormatting.func_110646_a((String)string));
        }

        public int func_78263_a(char p_78263_1_) {
            return this.wrapped.func_78263_a(p_78263_1_);
        }
    }
}

