/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.api.energy.ItemEnergyContainer;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.IHasPlayerRenderer;
import crazypants.enderio.item.MagnetController;
import crazypants.enderio.item.MagnetLayer;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.util.BaublesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API")
public class ItemMagnet
extends ItemEnergyContainer
implements IResourceTooltipProvider,
IBauble,
EnderCoreMethods.IOverlayRenderAware,
IHasPlayerRenderer {
    private static final String ACTIVE_KEY = "magnetActive";
    static MagnetController controller = new MagnetController();

    public static void setActive(ItemStack item, boolean active) {
        if (item == null) {
            return;
        }
        NBTTagCompound nbt = ItemUtil.getOrCreateNBT((ItemStack)item);
        nbt.func_74757_a(ACTIVE_KEY, active);
    }

    public static boolean isActive(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77978_p() == null) {
            return false;
        }
        if (!item.func_77978_p().func_74764_b(ACTIVE_KEY)) {
            return false;
        }
        return item.func_77978_p().func_74767_n(ACTIVE_KEY);
    }

    public static boolean hasPower(ItemStack itemStack) {
        int energyStored = DarkSteelItems.itemMagnet.getEnergyStored(itemStack);
        return energyStored > 0 && energyStored >= Config.magnetPowerUsePerSecondRF;
    }

    public static void drainPerSecondPower(ItemStack itemStack) {
        DarkSteelItems.itemMagnet.extractEnergy(itemStack, Config.magnetPowerUsePerSecondRF, false);
    }

    public static ItemMagnet create() {
        ItemMagnet result = new ItemMagnet();
        result.init();
        MinecraftForge.EVENT_BUS.register((Object)controller);
        return result;
    }

    protected ItemMagnet() {
        super(Config.magnetPowerCapacityRF, Config.magnetPowerCapacityRF / 100);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemMagnet.getUnlocalisedName());
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemMagnet.getUnlocalisedName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack item) {
        return ItemMagnet.isActive(item);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a("Energy", energy);
    }

    void setFull(ItemStack container) {
        this.setEnergy(container, Config.magnetPowerCapacityRF);
    }

    public ItemStack func_77659_a(ItemStack equipped, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            ItemMagnet.setActive(equipped, !ItemMagnet.isActive(equipped));
        }
        return equipped;
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    @Optional.Method(modid="Baubles|API")
    public BaubleType getBaubleType(ItemStack itemstack) {
        BaubleType t = null;
        try {
            t = BaubleType.valueOf((String)Config.magnetBaublesType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t != null ? t : BaubleType.AMULET;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && ItemMagnet.isActive(itemstack) && ItemMagnet.hasPower(itemstack) && ((EntityPlayer)player).func_110143_aJ() > 0.0f) {
            controller.doHoover((EntityPlayer)player);
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(itemstack);
                IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles != null) {
                    for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                        if (baubles.func_70301_a(i) != itemstack) continue;
                        baubles.func_70299_a(i, itemstack);
                    }
                }
            }
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return Config.magnetAllowInBaublesSlot && (Config.magnetAllowDeactivatedInBaublesSlot || ItemMagnet.isActive(itemstack));
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        return MagnetLayer.instance;
    }
}

