/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Sets;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
EnderCoreMethods.IOverlayRenderAware {
    public static final String NAME = "darkSteel_pickaxe";
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelPickaxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        if (!ItemDarkSteelPickaxe.isEquipped(player)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.func_71045_bC()) >= requiredPower;
    }

    public static ItemDarkSteelPickaxe create() {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(NAME);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        SpoonUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    public boolean func_179218_a(ItemStack item, World world, Block block, BlockPos pos, EntityLivingBase entLiving) {
        if ((double)block.func_176195_g(world, pos) != 0.0 && this.useObsidianEffeciency(item, block)) {
            this.extractEnergy(item, Config.darkSteelPickPowerUseObsidian, false);
        }
        return super.func_179218_a(item, world, block, pos, entLiving);
    }

    public boolean func_180614_a(ItemStack item, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.isTravelUpgradeActive(player, item) && world.field_72995_K) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hitX, hitX, hitX);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    static boolean doRightClickItemPlace(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        int slot;
        int current = player.field_71071_by.field_70461_c;
        int n = slot = current == 0 && Config.slotZeroPlacesEight ? 8 : current + 1;
        if (slot < 9 && player.field_71071_by.field_70462_a[slot] != null && !(player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof IDarkSteelItem)) {
            player.field_71071_by.field_70461_c = slot;
            Minecraft mc = Minecraft.func_71410_x();
            boolean result = mc.field_71442_b.func_178890_a(mc.field_71439_g, mc.field_71441_e, player.field_71071_by.field_70462_a[slot], mc.field_71476_x.func_178782_a(), mc.field_71476_x.field_178784_b, mc.field_71476_x.field_72307_f);
            player.field_71071_by.field_70461_c = current;
            return result;
        }
        return false;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelPickPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block == Blocks.field_150431_aC ? true : block == Blocks.field_150433_aE || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(ItemStack item) {
        return SpoonUpgrade.loadFromItem(item) != null;
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        if (this.useObsidianEffeciency(stack, state.func_177230_c())) {
            return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered + (float)Config.darkSteelPickEffeciencyObsidian;
        }
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.getDigSpeed(stack, state);
    }

    public static boolean isToolEffective(IBlockState state, ItemStack stack) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack item, Block block) {
        if (block.func_149688_o() == Material.field_151592_s) {
            return this.field_77864_a;
        }
        return super.func_150893_a(item, block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useObsidianEffeciency(ItemStack item, Block block) {
        boolean useObsidianSpeed = false;
        int energy = this.getEnergyStored(item);
        if (energy <= Config.darkSteelPickPowerUseObsidian) return useObsidianSpeed;
        if (block == Blocks.field_150343_Z) {
            return true;
        }
        boolean bl = false;
        useObsidianSpeed = bl;
        if (useObsidianSpeed) return useObsidianSpeed;
        if (!(Config.darkSteelPickApplyObsidianEffeciencyAtHardess > 0.0f)) return useObsidianSpeed;
        try {
            if (block == null) return false;
            BlockPos blockPos = new BlockPos(-1, -1, -1);
            if (!(block.func_176195_g(null, blockPos) >= Config.darkSteelPickApplyObsidianEffeciencyAtHardess)) return false;
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return useObsidianSpeed;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        if (this.hasSpoonUpgrade(stack)) {
            set.add("shovel");
        }
        return set;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)NAME);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyObsidian + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effObs") + " ");
            list.add(EnumChatFormatting.WHITE + "     " + "(" + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.cost") + " " + PowerDisplayUtil.formatPower(Config.darkSteelPickPowerUseObsidian) + " " + PowerDisplayUtil.abrevation() + ")");
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped) {
        return ItemDarkSteelPickaxe.isEquipped(ep) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isTravelUpgradeActive(player, stack)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, world, player, TravelSource.STAFF)) {
                player.func_71038_i();
                return stack;
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, player)) {
                player.func_71038_i();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }
}

