/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.jei.RecipeHandler;
import crazypants.enderio.jei.RecipeWrapper;
import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.alloy.GuiAlloySmelter;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class AlloyRecipeCategory
extends BlankRecipeCategory {
    @Nonnull
    public static final String UID = "AlloySmelter";
    private int xOff = 45;
    private int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated flame;
    private AlloyRecipe currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new RecipeHandler<AlloyRecipe>(AlloyRecipe.class, UID)});
        registry.addRecipeClickArea(GuiAlloySmelter.class, 155, 42, 16, 16, new String[]{UID});
        ArrayList<AlloyRecipe> result = new ArrayList<AlloyRecipe>();
        for (IRecipe iRecipe : AlloyRecipeManager.getInstance().getRecipes()) {
            result.add(new AlloyRecipe(iRecipe));
        }
        for (IRecipe iRecipe : AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes()) {
            result.add(new AlloyRecipe(iRecipe));
        }
        registry.addRecipes(result);
    }

    public AlloyRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("alloySmelter");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 82, 78);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 0, 13, 13);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        String localizedName = EnderIO.blockAlloySmelter.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 56 - this.xOff, 36 - this.yOff);
        this.flame.draw(minecraft, 103 - this.xOff, 36 - this.yOff);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.currentRecipe == null) {
            return;
        }
        String energyString = PowerDisplayUtil.formatPower(this.currentRecipe.getEnergyRequired()) + " " + PowerDisplayUtil.abrevation();
        minecraft.field_71466_p.func_175065_a(energyString, (float)(108 - this.xOff), (float)(62 - this.yOff), 0x808080, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 53 - this.xOff, 16 - this.yOff);
        guiItemStacks.init(1, true, 78 - this.xOff, 6 - this.yOff);
        guiItemStacks.init(2, true, 102 - this.xOff, 16 - this.yOff);
        guiItemStacks.init(3, false, 78 - this.xOff, 57 - this.yOff);
        List inputs = recipeWrapper.getInputs();
        for (int index = 0; index < inputs.size(); ++index) {
            Object ingredients = inputs.get(index);
            if (ingredients == null) continue;
            guiItemStacks.setFromRecipe(index, ingredients);
        }
        List outputs = recipeWrapper.getOutputs();
        if (outputs != null) {
            guiItemStacks.setFromRecipe(3, outputs);
        }
        this.currentRecipe = recipeWrapper instanceof AlloyRecipe ? (AlloyRecipe)recipeWrapper : null;
    }

    public static class AlloyRecipe
    extends RecipeWrapper {
        public AlloyRecipe(IRecipe recipe) {
            super(recipe);
        }
    }
}

