/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.IModObject;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.PacketIoMode;
import crazypants.enderio.machine.PacketItemBuffer;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.TextureRegistry;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.waila.IWailaInfoProvider;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMachineBlock<T extends AbstractMachineEntity>
extends BlockEio<T>
implements IGuiHandler,
IResourceTooltipProvider,
IWailaInfoProvider,
ISmartRenderAwareBlock {
    public static final TextureRegistry.TextureSupplier selectedFaceIcon = TextureRegistry.registerTexture("blocks/overlays/selectedFace");
    protected final Random random;
    protected final IModObject modObject;

    protected AbstractMachineBlock(IModObject mo, Class<T> teClass, Class<? extends ItemBlock> itemBlockClass, Material mat) {
        super(mo.getUnlocalisedName(), teClass, itemBlockClass, mat);
        this.modObject = mo;
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
        this.random = new Random();
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
    }

    protected AbstractMachineBlock(IModObject mo, Class<T> teClass, Material mat) {
        this(mo, teClass, null, mat);
    }

    protected AbstractMachineBlock(IModObject mo, Class<T> teClass, Class<? extends ItemBlock> itemBlockClass) {
        this(mo, teClass, itemBlockClass, new Material(MapColor.field_151668_h));
    }

    protected AbstractMachineBlock(IModObject mo, Class<T> teClass) {
        this(mo, teClass, null, new Material(MapColor.field_151668_h));
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
            AbstractMachineEntity tileEntity = (AbstractMachineEntity)this.getTileEntity(world, pos);
            if (tileEntity != null) {
                this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected abstract void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nonnull T var4);

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, this.getGuiId(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable AbstractMachineEntity te, ItemStack drop) {
        if (te != null) {
            te.writeToItemStack(drop);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        AbstractMachineEntity te = (AbstractMachineEntity)world.func_175625_s(pos);
        te.setFacing(this.getFacingForHeading(heading));
        te.readFromItemStack(stack);
        if (world.field_72995_K) {
            return;
        }
        world.func_175689_h(pos);
    }

    protected EnumFacing getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.WEST;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175689_h(pos);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity ent = world.func_175625_s(pos);
        if (ent instanceof AbstractMachineEntity) {
            AbstractMachineEntity te = (AbstractMachineEntity)ent;
            te.onNeighborBlockChange(neighborBlock);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (this.isActive((IBlockAccess)world, x, y = pos.func_177956_o(), z = pos.func_177952_p())) {
            float startX = (float)x + 1.0f;
            float startY = (float)y + 1.0f;
            float startZ = (float)z + 1.0f;
            for (int i = 0; i < 4; ++i) {
                float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                float zOffset = -0.2f - rand.nextFloat() * 0.6f;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected abstract int getGuiId();

    protected boolean isActive(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof AbstractMachineEntity) {
            return ((AbstractMachineEntity)te).isActive();
        }
        return false;
    }

    protected boolean isActive(IBlockAccess blockAccess, int x, int y, int z) {
        return this.isActive(blockAccess, new BlockPos(x, y, z));
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 7;
    }

    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(IoMode mode, EnumFacing side) {
        switch (mode) {
            case NONE: {
                return IOMode.EnumIOMode.NONE;
            }
            case PULL: {
                return IOMode.EnumIOMode.PULL;
            }
            case PUSH: {
                return IOMode.EnumIOMode.PUSH;
            }
            case PUSH_PULL: {
                return IOMode.EnumIOMode.PUSHPULL;
            }
            case DISABLED: {
                return IOMode.EnumIOMode.DISABLED;
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPaintSource(this.func_176223_P(), world, pos);
    }

    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        AbstractMachineEntity te;
        if (this instanceof IPaintable && (te = (AbstractMachineEntity)this.getTileEntity(world, pos)) instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)((Object)te)).setPaintSource(paintSource);
        }
    }

    public void setPaintSource(Block block, ItemStack stack, IBlockState paintSource) {
        if (this instanceof IPaintable) {
            PainterUtil2.setSourceBlock(stack, paintSource);
        }
    }

    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        AbstractMachineEntity te;
        if (this instanceof IPaintable && (te = (AbstractMachineEntity)this.getTileEntity(world, pos)) instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)((Object)te)).getPaintSource();
        }
        return null;
    }

    public IBlockState getPaintSource(Block block, ItemStack stack) {
        if (this instanceof IPaintable) {
            return PainterUtil2.getSourceBlock(stack);
        }
        return null;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return this instanceof IPaintable ? true : super.canRenderInLayer(layer);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState paintSource;
        if (this instanceof IPaintable && (paintSource = this.getPaintSource(worldIn.func_180495_p(pos), worldIn, pos)) != null) {
            try {
                return paintSource.func_177230_c().func_180662_a(worldIn, pos, renderPass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    static {
        PacketHandler.INSTANCE.registerMessage(PacketIoMode.class, PacketIoMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemBuffer.class, PacketItemBuffer.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerStorage.class, PacketPowerStorage.class, PacketHandler.nextID(), Side.CLIENT);
    }
}

