/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.EnderIO;
import crazypants.enderio.power.IPowerContainer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPowerStorage
implements IMessage,
IMessageHandler<PacketPowerStorage, IMessage> {
    private BlockPos pos;
    private int storedEnergy;

    public PacketPowerStorage() {
    }

    public PacketPowerStorage(IPowerContainer ent) {
        this.pos = ent.getLocation().getBlockPos();
        this.storedEnergy = ent.getEnergyStored();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        if (this.pos != null) {
            throw new RuntimeException("Oops, seems mc is recycling these messages. Need to copy them over before enqueuing them for the main thread");
        }
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.storedEnergy = buf.readInt();
    }

    public IMessage onMessage(PacketPowerStorage message, MessageContext ctx) {
        TileEntity te;
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        if (player != null && player.field_70170_p != null && (te = player.field_70170_p.func_175625_s(message.pos)) instanceof IPowerContainer) {
            IPowerContainer me = (IPowerContainer)te;
            me.setEnergyStored(message.storedEnergy);
        }
        return null;
    }
}

