/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.buffer.TileBuffer;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum BufferType implements IStringSerializable
{
    ITEM(true, false, false),
    POWER(false, true, false),
    OMNI(true, true, false),
    CREATIVE(true, true, true);

    final boolean hasInventory;
    final boolean hasPower;
    final boolean isCreative;
    public static final PropertyEnum<BufferType> TYPE;

    private BufferType(boolean hasInventory, boolean hasPower, boolean isCreative) {
        this.hasInventory = hasInventory;
        this.hasPower = hasPower;
        this.isCreative = isCreative;
    }

    public static BufferType get(TileBuffer buffer) {
        return !buffer.hasPower() ? ITEM : (!buffer.hasInventory() ? POWER : (!buffer.isCreative() ? OMNI : CREATIVE));
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getUnlocalizedName() {
        return "tile." + ModObject.blockBuffer.getUnlocalisedName() + "." + this.func_176610_l();
    }

    public static BufferType getTypeFromMeta(int meta) {
        return BufferType.values()[meta >= 0 && meta < BufferType.values().length ? meta : 0];
    }

    public static int getMetaFromType(BufferType value) {
        return value.ordinal();
    }

    public static ItemStack getStack(BufferType type) {
        return new ItemStack((Block)EnderIO.blockBuffer, 1, type.ordinal());
    }

    static {
        TYPE = PropertyEnum.func_177709_a((String)"type", BufferType.class);
    }
}

