/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;

public enum CapBankType implements IStringSerializable
{
    NONE("NONE", "tile.blockCapBank.none", 0, 0, false, true),
    CREATIVE("CREATIVE", "tile.blockCapBank.creative", 500000, Config.capacitorBankTierTwoMaxStorageRF, false, true),
    SIMPLE("SIMPLE", "tile.blockCapBank.simple", Config.capacitorBankTierOneMaxIoRF, Config.capacitorBankTierOneMaxStorageRF, true, false),
    ACTIVATED("ACTIVATED", "tile.blockCapBank.activated", Config.capacitorBankTierTwoMaxIoRF, Config.capacitorBankTierTwoMaxStorageRF, true, false),
    VIBRANT("VIBRANT", "tile.blockCapBank.vibrant", Config.capacitorBankTierThreeMaxIoRF, Config.capacitorBankTierThreeMaxStorageRF, true, false);

    public static final PropertyEnum<CapBankType> KIND;
    private static final List<CapBankType> TYPES;
    private final String uid;
    private final String unlocalizedName;
    private final int maxIO;
    private final int maxStored;
    private final boolean isMultiblock;
    private final boolean isCreative;

    public static List<CapBankType> types() {
        return TYPES;
    }

    public static int getMetaFromType(CapBankType type) {
        for (int i = 0; i < TYPES.size(); ++i) {
            if (TYPES.get(i) != type) continue;
            return i;
        }
        return 1;
    }

    public static CapBankType getTypeFromMeta(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(TYPES.size() - 1));
        return CapBankType.types().get(meta);
    }

    public static CapBankType getTypeFromUID(String uid) {
        for (CapBankType type : TYPES) {
            if (!type.uid.equals(uid)) continue;
            return type;
        }
        return ACTIVATED;
    }

    private CapBankType(String uid, String unlocalizedName, int maxIO, int maxStored, boolean isMultiblock, boolean isCreative) {
        this.uid = uid;
        this.unlocalizedName = unlocalizedName;
        this.maxIO = maxIO;
        this.maxStored = maxStored;
        this.isMultiblock = isMultiblock;
        this.isCreative = isCreative;
    }

    public int getMaxIO() {
        return this.maxIO;
    }

    public int getMaxEnergyStored() {
        return this.maxStored;
    }

    public boolean isMultiblock() {
        return this.isMultiblock;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getUid() {
        return this.uid;
    }

    public void writeTypeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74778_a("type", this.getUid());
    }

    public static CapBankType readTypeFromNBT(NBTTagCompound nbtRoot) {
        if (nbtRoot == null || !nbtRoot.func_74764_b("type")) {
            return ACTIVATED;
        }
        return CapBankType.getTypeFromUID(nbtRoot.func_74779_i("type"));
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        KIND = PropertyEnum.func_177709_a((String)"kind", CapBankType.class);
        TYPES = new ArrayList<CapBankType>();
        TYPES.add(CREATIVE);
        TYPES.add(SIMPLE);
        TYPES.add(ACTIVATED);
        TYPES.add(VIBRANT);
    }
}

