/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PacketCapBank<T extends PacketCapBank<?, ?>, Q extends IMessage>
implements IMessage,
IMessageHandler<T, Q> {
    private long pos;

    public PacketCapBank() {
    }

    public PacketCapBank(TileCapBank capBank) {
        this.pos = capBank.func_174877_v().func_177986_g();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
    }

    public BlockPos getPos() {
        return BlockPos.func_177969_a((long)this.pos);
    }

    public Q onMessage(T message, MessageContext ctx) {
        TileCapBank te = this.getTileEntity(message, ctx);
        if (te == null) {
            return null;
        }
        return this.handleMessage(te, message, ctx);
    }

    protected abstract Q handleMessage(TileCapBank var1, T var2, MessageContext var3);

    protected TileCapBank getTileEntity(T message, MessageContext ctx) {
        World worldObj = this.getWorld(ctx);
        if (worldObj == null) {
            return null;
        }
        TileEntity te = worldObj.func_175625_s(((PacketCapBank)message).getPos());
        if (te == null) {
            return null;
        }
        if (te instanceof TileCapBank) {
            return (TileCapBank)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        return EnderIO.proxy.getClientWorld();
    }
}

