/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class CocoaFarmer
extends CustomSeedFarmer {
    public CocoaFarmer() {
        super(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, 3));
        this.requiresFarmland = false;
        if (!Config.farmHarvestJungleWhenCocoa) {
            this.disableTreeFarm = true;
        }
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        return false;
    }

    @Override
    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        return false;
    }

    @Override
    protected boolean canPlant(World worldObj, BlockCoord bc) {
        return this.getPlantDirection(worldObj, bc) != null;
    }

    private EnumFacing getPlantDirection(World worldObj, BlockCoord bc) {
        if (!worldObj.func_175623_d(bc.getBlockPos())) {
            return null;
        }
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int x = bc.x + dir.func_82601_c();
            int y = bc.y + dir.func_96559_d();
            int z = bc.z + dir.func_82599_e();
            BlockPos p = bc.getBlockPos().func_177972_a(dir);
            if (!this.validBlock(worldObj.func_180495_p(p))) continue;
            return dir;
        }
        return null;
    }

    private boolean validBlock(IBlockState bs) {
        return bs.func_177230_c() == Blocks.field_150364_r;
    }
}

