/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class NaturaBerryFarmer
extends PickableFarmer {
    public NaturaBerryFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (block != this.getPlantedBlock()) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        HarvestResult res = new HarvestResult();
        BlockCoord checkBlock = bc;
        for (int i = 0; i < 5 && farm.hasHoe(); ++i) {
            IHarvestResult blockRes;
            meta = farm.getBlockState(checkBlock.getBlockPos());
            block = farm.getBlock(checkBlock);
            if (super.canHarvest(farm, bc, block, meta) && (blockRes = super.harvestBlock(farm, checkBlock, block, meta)) != null) {
                res.getHarvestedBlocks().add(checkBlock.getBlockPos());
                List<EntityItem> addToDrops = blockRes.getDrops();
                for (EntityItem stack : addToDrops) {
                    res.getDrops().add(stack);
                }
            }
            checkBlock = checkBlock.getLocation(EnumFacing.UP);
        }
        if (res.getHarvestedBlocks().isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState bs) {
        int meta = bs.func_177230_c().func_176201_c(bs);
        if (!Config.farmEssenceBerriesEnabled && "tile.ore.berries.two".equals(block.func_149739_a()) && meta == this.grownBlockMeta) {
            return false;
        }
        BlockCoord checkBlock = bc;
        for (int i = 0; i < 5; ++i) {
            bs = farm.getBlockState(checkBlock.getBlockPos());
            block = checkBlock.getBlock((IBlockAccess)farm.func_145831_w());
            if (super.canHarvest(farm, checkBlock, block, bs)) {
                return true;
            }
            checkBlock = checkBlock.getLocation(EnumFacing.UP);
        }
        return false;
    }
}

