/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class TreeFarmer
implements IFarmerJoe {
    private static final HeightComparator comp = new HeightComparator();
    protected Block sapling;
    protected ItemStack saplingItem;
    protected Block[] woods;
    protected TreeHarvestUtil harvester = new TreeHarvestUtil();
    private boolean ignoreMeta;

    public TreeFarmer(Block sapling, Block ... wood) {
        this.sapling = sapling;
        if (sapling != null) {
            this.saplingItem = new ItemStack(sapling);
            FarmStationContainer.slotItemsSeeds.add(this.saplingItem);
        }
        for (Block awood : this.woods = wood) {
            FarmStationContainer.slotItemsProduce.add(new ItemStack(awood));
        }
    }

    public TreeFarmer(boolean ignoreMeta, Block sapling, Block ... wood) {
        this(sapling, wood);
        this.ignoreMeta = ignoreMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState bs) {
        return this.isWood(block);
    }

    protected boolean isWood(Block block) {
        for (Block wood : this.woods) {
            if (block != wood) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return stack != null && stack.func_77973_b() == this.saplingItem.func_77973_b();
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (block == this.sapling) {
            return true;
        }
        return this.plantFromInventory(farm, bc, block, meta);
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        ItemStack seed;
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && (seed = farm.takeSeedFromSupplies(this.saplingItem, bc, false)) != null) {
            return this.plant(farm, worldObj, bc, seed);
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc) {
        BlockPos grnPos = bc.getBlockPos().func_177977_b();
        IBlockState bs = worldObj.func_180495_p(grnPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.sapling;
        return this.sapling.func_176196_c(worldObj, bc.getBlockPos()) && ground.canSustainPlant((IBlockAccess)worldObj, grnPos, EnumFacing.UP, plantable);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc, ItemStack seed) {
        worldObj.func_175698_g(bc.getBlockPos());
        if (this.canPlant(worldObj, bc)) {
            worldObj.func_180501_a(bc.getBlockPos(), this.sapling.func_176203_a(seed.func_77952_i()), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        boolean hasAxe = farm.hasAxe();
        if (!hasAxe) {
            return null;
        }
        HarvestResult res = new HarvestResult();
        this.harvester.harvest(farm, this, bc.getBlockPos(), res);
        Collections.sort(res.harvestedBlocks, comp);
        ArrayList<BlockPos> actualHarvests = new ArrayList<BlockPos>();
        boolean hasShears = farm.hasShears();
        int noShearingPercentage = farm.isLowOnSaplings(bc);
        int shearCount = 0;
        for (int i = 0; i < res.harvestedBlocks.size() && hasAxe; ++i) {
            List drops;
            BlockPos coord = res.harvestedBlocks.get(i);
            Block blk = farm.getBlock(coord);
            boolean wasSheared = false;
            boolean wasAxed = false;
            boolean wasWood = this.isWood(blk);
            if (blk instanceof IShearable && hasShears && shearCount / res.harvestedBlocks.size() + noShearingPercentage < 100) {
                drops = ((IShearable)blk).onSheared(null, (IBlockAccess)farm.func_145831_w(), coord, 0);
                wasSheared = true;
                shearCount += 100;
            } else {
                drops = blk.getDrops((IBlockAccess)farm.func_145831_w(), coord, farm.getBlockState(coord), farm.getAxeLootingValue());
                wasAxed = true;
            }
            if (drops != null) {
                for (ItemStack drop : drops) {
                    res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, drop.func_77946_l()));
                }
            }
            if (wasAxed && !wasWood) {
                wasAxed = Config.farmAxeDamageOnLeafBreak;
                IBlockState bs = farm.getBlockState(coord);
                if ((bs.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.OAK || bs.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK) && farm.func_145831_w().field_73012_v.nextInt(200) == 0) {
                    res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.field_151034_e)));
                }
            }
            farm.actionPerformed(wasWood || wasSheared);
            if (wasAxed) {
                farm.damageAxe(blk, new BlockCoord(coord));
                hasAxe = farm.hasAxe();
            } else if (wasSheared) {
                farm.damageShears(blk, new BlockCoord(coord));
                hasShears = farm.hasShears();
            }
            farm.func_145831_w().func_175698_g(coord);
            actualHarvests.add(coord);
        }
        if (!hasAxe) {
            farm.setNotification("noAxe");
        }
        res.harvestedBlocks.clear();
        res.harvestedBlocks.addAll(actualHarvests);
        return res;
    }

    public boolean getIgnoreMeta() {
        return this.ignoreMeta;
    }

    private static class HeightComparator
    implements Comparator<BlockPos> {
        private HeightComparator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return HeightComparator.compare(o2.func_177956_o(), o1.func_177956_o());
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

