/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class TreeHarvestUtil {
    private int horizontalRange;
    private int verticalRange;
    private BlockCoord origin;

    public void harvest(TileFarmStation farm, TreeFarmer farmer, BlockPos bc, HarvestResult res) {
        this.horizontalRange = farm.getFarmSize() + 7;
        this.verticalRange = 30;
        this.harvest(farm.func_145831_w(), farm.getLocation(), bc, res, farmer.getIgnoreMeta());
    }

    public void harvest(World world, BlockPos bc, HarvestResult res) {
        this.horizontalRange = 12;
        this.verticalRange = 30;
        this.origin = new BlockCoord(bc);
        IBlockState wood = world.func_180495_p(bc);
        this.harvestUp(world, bc, res, new HarvestTarget(wood));
    }

    private void harvest(World world, BlockCoord origin, BlockPos bc, HarvestResult res, boolean ignoreMeta) {
        this.origin = new BlockCoord(origin);
        IBlockState wood = world.func_180495_p(bc);
        if (ignoreMeta) {
            this.harvestUp(world, bc, res, new BaseHarvestTarget(wood.func_177230_c()));
        } else {
            this.harvestUp(world, bc, res, new HarvestTarget(wood));
        }
    }

    protected void harvestUp(World world, BlockPos bc, HarvestResult res, BaseHarvestTarget target) {
        boolean isLeaves;
        if (!this.isInHarvestBounds(bc) || res.harvestedBlocks.contains(bc)) {
            return;
        }
        IBlockState bs = world.func_180495_p(bc);
        Block blk = bs.func_177230_c();
        boolean bl = isLeaves = blk.func_149688_o() == Material.field_151584_j;
        if (target.isTarget(bs) || isLeaves) {
            res.harvestedBlocks.add(bc);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == EnumFacing.DOWN) continue;
                this.harvestUp(world, bc.func_177972_a(dir), res, target);
            }
        } else {
            this.harvestAdjacentWood(world, bc, res, target);
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                BlockPos loc = bc.func_177972_a(dir);
                Block targetBlock = world.func_180495_p(loc).func_177230_c();
                if (targetBlock.func_149688_o() != Material.field_151584_j) continue;
                this.harvestAdjacentWood(world, loc, res, target);
            }
        }
    }

    private void harvestAdjacentWood(World world, BlockPos bc, HarvestResult res, BaseHarvestTarget target) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos targ = bc.func_177972_a(dir);
            if (!target.isTarget(world.func_180495_p(targ))) continue;
            this.harvestUp(world, targ, res, target);
        }
    }

    private boolean isInHarvestBounds(BlockPos bc) {
        int dist = Math.abs(this.origin.x - bc.func_177958_n());
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.z - bc.func_177952_p());
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.y - bc.func_177956_o());
        return dist <= this.verticalRange;
    }

    private static class BaseHarvestTarget {
        private final Block wood;

        BaseHarvestTarget(Block wood) {
            this.wood = wood;
        }

        boolean isTarget(IBlockState bs) {
            return bs.func_177230_c() == this.wood;
        }
    }

    private static final class HarvestTarget
    extends BaseHarvestTarget {
        IBlockState bs;
        BlockPlanks.EnumType variant;

        HarvestTarget(IBlockState bs) {
            super(bs.func_177230_c());
            this.bs = bs;
            this.variant = this.getVariant(bs);
        }

        private BlockPlanks.EnumType getVariant(IBlockState bs2) {
            BlockPlanks.EnumType v = (BlockPlanks.EnumType)this.bs.func_177229_b((IProperty)BlockNewLog.field_176300_b);
            if (v == null) {
                v = (BlockPlanks.EnumType)this.bs.func_177229_b((IProperty)BlockOldLog.field_176301_b);
            }
            return v;
        }

        @Override
        boolean isTarget(IBlockState bs) {
            if (this.variant == null) {
                return super.isTarget(bs);
            }
            return super.isTarget(bs) && this.variant == this.getVariant(bs);
        }
    }
}

