/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.IoConfigRenderer;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public abstract class GuiMachineBase<T extends AbstractMachineEntity>
extends GuiContainerBaseEIO {
    public static final Vector4f PUSH_COLOR = new Vector4f(0.8f, 0.4f, 0.1f, 0.5f);
    public static final Vector4f PULL_COLOR = new Vector4f(0.1f, 0.4f, 0.8f, 0.5f);
    public static final int BUTTON_SIZE = 16;
    private static final int CONFIG_ID = 8962349;
    private static final int RECIPE_ID = 8962350;
    private final T tileEntity;
    protected RedstoneModeButton redstoneButton;
    private final GuiOverlayIoConfig configOverlay;
    protected final GuiButtonIoConfig configB;
    protected IconButton recipeButton;
    protected List<GuiToolTip> progressTooltips;
    protected int lastProgressTooltipValue = -1;

    protected GuiMachineBase(T machine, Container par1Container, String ... guiTexture) {
        super(par1Container, guiTexture);
        this.tileEntity = machine;
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        int x = this.getXSize() - 5 - 16;
        int y = 5;
        this.redstoneButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y, (IRedstoneModeControlable)this.tileEntity, new BlockCoord(this.tileEntity));
        this.configOverlay = new GuiOverlayIoConfig((IIoConfigurable)machine);
        this.addOverlay(this.configOverlay);
        this.configB = new GuiButtonIoConfig((IGuiScreen)this, 8962349, x, y += 19, (IIoConfigurable)machine, this.configOverlay);
        this.recipeButton = new IconButton((IGuiScreen)this, 8962350, x, y += 19, (IWidgetIcon)IconEIO.RECIPE);
        this.recipeButton.field_146125_m = false;
        this.recipeButton.setIconMargin(1, 1);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.onGuiInit();
        this.configB.onGuiInit();
        this.recipeButton.onGuiInit();
    }

    protected boolean showRecipeButton() {
        return EnderIO.proxy.isAnEiInstalled();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.showRecipeButton()) {
            this.recipeButton.field_146125_m = true;
        }
        super.func_146976_a(par1, par2, par3);
        this.renderSlotHighlights();
    }

    public void renderSlotHighlights() {
        IoMode mode;
        IoConfigRenderer.SelectedFace sel = this.configOverlay.getSelection();
        if (sel != null && (mode = sel.config.getIoMode(sel.face)) != null) {
            this.renderSlotHighlights(mode);
        }
    }

    public void renderSlotHighlights(IoMode mode) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.tileEntity).getSlotDefinition();
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (invSlot.field_75224_c != this.tileEntity) continue;
            if ((mode == IoMode.PULL || mode == IoMode.PUSH_PULL) && slotDef.isInputSlot(invSlot.getSlotIndex())) {
                this.renderSlotHighlight(invSlot, PULL_COLOR);
                continue;
            }
            if (mode != IoMode.PUSH && mode != IoMode.PUSH_PULL || !slotDef.isOutputSlot(invSlot.getSlotIndex())) continue;
            this.renderSlotHighlight(invSlot, PUSH_COLOR);
        }
    }

    protected void renderSlotHighlight(int slot, Vector4f col) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(Slot invSlot, Vector4f col) {
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(Vector4f col, int x, int y, int width, int height) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)width, (double)height, (Vector4f)col);
        GL11.glDisable((int)3042);
    }

    protected boolean isConfigOverlayEnabled() {
        return this.configOverlay.isVisible();
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected void addProgressTooltip(int x, int y, int w, int h) {
        if (this.progressTooltips == null) {
            this.progressTooltips = new ArrayList<GuiToolTip>();
        }
        GuiToolTip tt = new GuiToolTip(new Rectangle(x, y, w, h), (String[])null);
        this.progressTooltips.add(tt);
        this.addToolTip(tt);
    }

    protected final void updateProgressTooltips(int scaledProgress, float progress) {
        if (this.lastProgressTooltipValue == scaledProgress || this.progressTooltips == null) {
            return;
        }
        this.lastProgressTooltipValue = scaledProgress;
        if (scaledProgress < 0) {
            for (GuiToolTip tt : this.progressTooltips) {
                tt.setIsVisible(false);
            }
            return;
        }
        String msg = this.formatProgressTooltip(scaledProgress, progress);
        String[] tooltip = msg.split("\\|");
        for (GuiToolTip tt : this.progressTooltips) {
            tt.setToolTipText(tooltip);
            tt.setIsVisible(true);
        }
    }

    protected String formatProgressTooltip(int scaledProgress, float progress) {
        return MessageFormat.format(EnderIO.lang.localize("gui.progress"), scaledProgress);
    }

    protected int scaleProgressForTooltip(float progress) {
        return (int)(progress * 100.0f);
    }

    protected boolean shouldRenderProgress() {
        if (this.tileEntity instanceof IProgressTile) {
            float progress = ((IProgressTile)this.tileEntity).getProgress();
            if (progress > 0.0f && progress < 1.0f) {
                this.updateProgressTooltips(this.scaleProgressForTooltip(progress), progress);
                return true;
            }
            this.updateProgressTooltips(-1, -1.0f);
            return false;
        }
        return false;
    }

    protected int getProgressScaled(int scale) {
        if (this.getTileEntity() instanceof IProgressTile) {
            return Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.getTileEntity()));
        }
        return 0;
    }
}

