/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.monitor.DynaTextureProvider;
import crazypants.enderio.machine.monitor.StatArray;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPowerMonitorGraph
extends MessageTileEntity<TilePowerMonitor> {
    private int no;
    private int collectCount;
    private int pos;
    private byte[] data;

    public PacketPowerMonitorGraph() {
    }

    private PacketPowerMonitorGraph(TilePowerMonitor tile) {
        super((TileEntity)tile);
    }

    public static IMessage requestUpdate(TilePowerMonitor te, int no) {
        PacketPowerMonitorGraph msg = new PacketPowerMonitorGraph(te);
        msg.no = no;
        msg.collectCount = -1;
        msg.pos = -1;
        msg.data = null;
        return msg;
    }

    public static IMessage sendUpdate(TilePowerMonitor te, int no) {
        PacketPowerMonitorGraph msg = new PacketPowerMonitorGraph(te);
        msg.no = no;
        msg.collectCount = te.stats[no].getCollectCount();
        msg.pos = te.stats[no].getPos();
        msg.data = te.stats[no].getData();
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.no = buf.readShort();
        this.collectCount = buf.readShort();
        if (this.collectCount >= 0) {
            this.pos = buf.readShort();
            this.data = new byte[StatArray.BYTES * 2];
            buf.readBytes(this.data);
        } else {
            this.pos = -1;
            this.data = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.no);
        buf.writeShort(this.collectCount);
        if (this.collectCount >= 0) {
            buf.writeShort(this.pos);
            buf.writeBytes(this.data);
        }
    }

    public static class ClientHandler
    implements IMessageHandler<PacketPowerMonitorGraph, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPowerMonitorGraph msg, MessageContext ctx) {
            TilePowerMonitor te;
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            if (player != null && (te = (TilePowerMonitor)msg.getTileEntity(player.field_70170_p)) != null && msg.no >= 0 && msg.no < te.stats.length) {
                te.stats[msg.no].setCollectCount(msg.collectCount);
                te.stats[msg.no].setPos(msg.pos);
                te.stats[msg.no].setData(msg.data);
                if (msg.no == te.stats.length - 1 && te.dynaTextureProvider != null) {
                    ((DynaTextureProvider)te.dynaTextureProvider).updateTexture();
                }
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketPowerMonitorGraph, IMessage> {
        public IMessage onMessage(PacketPowerMonitorGraph msg, MessageContext ctx) {
            TilePowerMonitor te = (TilePowerMonitor)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null && msg.no >= 0 && msg.no < te.stats.length) {
                return PacketPowerMonitorGraph.sendUpdate(te, msg.no);
            }
            return null;
        }
    }
}

