/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.attractor;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeEntity;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.pathfinder.NodeProcessor;
import net.minecraft.world.pathfinder.WalkNodeProcessor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileAttractor
extends AbstractPowerConsumerEntity
implements IRanged {
    private AxisAlignedBB attractorBounds;
    private FakePlayer target;
    private Set<EntityLiving> tracking = new HashSet<EntityLiving>();
    private int tickCounter = 0;
    private int maxMobsAttracted = 20;
    private boolean showingRange;

    public TileAttractor() {
        super(new SlotDefinition(12, 0), CapacitorKey.ATTRACTOR_POWER_INTAKE, CapacitorKey.ATTRACTOR_POWER_BUFFER, CapacitorKey.ATTRACTOR_POWER_USE);
    }

    @Override
    public float getRange() {
        return CapacitorKey.ATTRACTOR_RANGE.get(this.getCapacitorData());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.field_145850_b.func_72838_d((Entity)new RangeEntity(this));
        }
    }

    @Override
    public World getRangeWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.attractorBounds = null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAttractor.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        return CapturedMob.containsSoul(itemstack);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!redstoneCheck || !this.hasPower()) {
            return false;
        }
        this.usePower();
        ++this.tickCounter;
        if (this.tickCounter < 10) {
            for (EntityLiving ent : this.tracking) {
                this.onEntityTick(ent);
            }
            return false;
        }
        this.tickCounter = 0;
        if (this.attractorBounds == null) {
            BoundingBox bb = new BoundingBox(new BlockCoord((TileEntity)this));
            bb = bb.scale(this.getRange(), this.getRange(), this.getRange());
            this.attractorBounds = new AxisAlignedBB((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        }
        HashSet<EntityLiving> trackingThisTick = new HashSet<EntityLiving>();
        List entsInBounds = this.field_145850_b.func_72872_a(EntityLiving.class, this.attractorBounds);
        for (EntityLiving ent : entsInBounds) {
            if (ent.field_70128_L || !this.isMobInFilter(ent)) continue;
            if (this.tracking.contains(ent)) {
                trackingThisTick.add(ent);
                this.onEntityTick(ent);
                continue;
            }
            if (this.tracking.size() >= this.maxMobsAttracted || !this.trackMob(ent)) continue;
            trackingThisTick.add(ent);
            this.onTracked(ent);
        }
        for (EntityLiving e : this.tracking) {
            if (trackingThisTick.contains(e)) continue;
            this.onUntracked(e);
        }
        this.tracking.clear();
        this.tracking = trackingThisTick;
        return false;
    }

    private void onUntracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().func_74757_a("EIO:tracked", false);
        }
    }

    private void onTracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().func_74757_a("EIO:tracked", true);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (EntityLiving e : this.tracking) {
            this.onUntracked(e);
        }
        this.tracking.clear();
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    FakePlayer getTarget() {
        if (this.target == null) {
            this.target = new Target();
        }
        return this.target;
    }

    public boolean canAttract(EntityLiving mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInFilter(mob) && this.isMobInRange(mob);
    }

    private boolean isMobInRange(EntityLiving mob) {
        return this.isMobInRange(mob, (int)(this.getRange() * this.getRange()));
    }

    private boolean isMobInRange(EntityLiving mob, int rangeIn) {
        if (mob == null) {
            return false;
        }
        return new Vector3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v).distanceSquared(new Vector3d(this.func_174877_v())) <= (double)rangeIn;
    }

    private boolean isMobInFilter(EntityLiving entity) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.inventory[i]);
            if (mob == null || !mob.isSameType((Entity)entity)) continue;
            return true;
        }
        return false;
    }

    private boolean trackMob(EntityLiving ent) {
        if (this.useSetTarget(ent)) {
            ((EntityMob)ent).func_70624_b((EntityLivingBase)this.getTarget());
            return true;
        }
        if (this.useSpecialCase(ent)) {
            return this.applySpecialCase(ent);
        }
        return this.attractyUsingAITask(ent);
    }

    private boolean attractyUsingAITask(EntityLiving ent) {
        this.tracking.add(ent);
        List entries = ent.field_70714_bg.field_75782_a;
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            if (!(entry.field_75733_a instanceof AttractTask)) continue;
            AttractTask at = (AttractTask)entry.field_75733_a;
            if (at.coord.equals((Object)new BlockCoord((TileEntity)this)) || !at.func_75253_b()) {
                remove = entry.field_75733_a;
                continue;
            }
            return false;
        }
        if (remove != null) {
            ent.field_70714_bg.func_85156_a(remove);
        }
        this.cancelCurrentTasks(ent);
        ent.field_70714_bg.func_75776_a(0, (EntityAIBase)new AttractTask(ent, this.getTarget(), new BlockCoord((TileEntity)this)));
        return true;
    }

    private void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
    }

    private boolean applySpecialCase(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(), 10.0f, 20.0f);
            return true;
        }
        if (ent instanceof EntitySilverfish) {
            EntitySilverfish es = (EntitySilverfish)ent;
            PathEntity pathentity = this.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(), this.getRange());
            es.func_70661_as().func_75484_a(pathentity, (double)es.func_70689_ay());
            return true;
        }
        return ent instanceof EntityBlaze;
    }

    private boolean useSpecialCase(EntityLiving ent) {
        return ent instanceof EntitySlime || ent instanceof EntitySilverfish || ent instanceof EntityBlaze;
    }

    private void onEntityTick(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(), 10.0f, 20.0f);
        } else if (ent instanceof EntitySilverfish) {
            if (this.tickCounter < 10) {
                return;
            }
            EntitySilverfish sf = (EntitySilverfish)ent;
            PathEntity pathentity = this.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(), this.getRange());
            sf.func_70661_as().func_75484_a(pathentity, (double)sf.func_70689_ay());
        } else if (ent instanceof EntityBlaze) {
            double z;
            double y;
            double x = (double)this.func_174877_v().func_177958_n() + 0.5 - ent.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.func_174877_v().func_177958_n() + 1.0 - ent.field_70163_u) * y + (z = (double)this.func_174877_v().func_177958_n() + 0.5 - ent.field_70161_v) * z);
            if (distance > 1.25) {
                double speed = 0.01;
                ent.field_70159_w += x / distance * speed;
                if (y > 0.0) {
                    ent.field_70181_x += ((double)0.3f - ent.field_70181_x) * (double)0.3f;
                }
                ent.field_70179_y += z / distance * speed;
            }
        } else if (ent instanceof EntityPigZombie || ent instanceof EntitySpider) {
            this.forceMove(ent);
        } else if (ent instanceof EntityEnderman) {
            ((EntityEnderman)ent).func_70624_b((EntityLivingBase)this.getTarget());
        }
    }

    private void forceMove(EntityLiving ent) {
        double z;
        double y;
        double x = (double)this.func_174877_v().func_177958_n() + 0.5 - ent.field_70165_t;
        double distance = Math.sqrt(x * x + (y = (double)this.func_174877_v().func_177956_o() + 1.0 - ent.field_70163_u) * y + (z = (double)this.func_174877_v().func_177952_p() + 0.5 - ent.field_70161_v) * z);
        if (distance > 2.0) {
            EntityMob mod = (EntityMob)ent;
            mod.func_70625_a((Entity)this.getTarget(), 180.0f, 0.0f);
            mod.func_70612_e(0.0f, 1.0f);
            if (mod.field_70163_u < (double)this.func_174877_v().func_177956_o()) {
                mod.func_70637_d(true);
            } else {
                mod.func_70637_d(false);
            }
        }
    }

    private boolean useSetTarget(EntityLiving ent) {
        return ent instanceof EntityPigZombie || ent instanceof EntitySpider || ent instanceof EntitySilverfish;
    }

    public PathEntity getPathEntityToEntity(Entity entity, Entity targetEntity, float range) {
        int targX = MathHelper.func_76128_c((double)targetEntity.field_70165_t);
        int targY = MathHelper.func_76128_c((double)(targetEntity.field_70163_u + 1.0));
        int targZ = MathHelper.func_76128_c((double)targetEntity.field_70161_v);
        PathFinder pf = new PathFinder((NodeProcessor)new WalkNodeProcessor());
        return pf.func_180782_a((IBlockAccess)this.field_145850_b, entity, new BlockPos(targX, targY, targZ), range);
    }

    private static class AttractTask
    extends EntityAIBase {
        private EntityLiving mob;
        private BlockCoord coord;
        private FakePlayer target;
        private int updatesSincePathing;
        private boolean started = false;

        private AttractTask(EntityLiving mob, FakePlayer target, BlockCoord coord) {
            this.mob = mob;
            this.coord = coord;
            this.target = target;
        }

        public boolean func_75250_a() {
            return this.func_75253_b();
        }

        public void func_75251_c() {
            this.started = false;
            this.updatesSincePathing = 0;
        }

        public boolean func_75253_b() {
            boolean res = false;
            TileEntity te = this.mob.field_70170_p.func_175625_s(this.coord.getBlockPos());
            if (te instanceof TileAttractor) {
                TileAttractor attractor = (TileAttractor)te;
                res = attractor.canAttract(this.mob);
            }
            return res;
        }

        public boolean func_75252_g() {
            return true;
        }

        public void func_75246_d() {
            if (!this.started || this.updatesSincePathing > 20) {
                this.started = true;
                boolean speed = true;
                boolean res = this.mob.func_70661_as().func_75497_a((Entity)this.target, (double)speed);
                if (!res) {
                    this.mob.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u + 1.0, this.target.field_70161_v, (double)speed);
                }
                this.updatesSincePathing = 0;
            } else {
                ++this.updatesSincePathing;
            }
        }
    }

    private class Target
    extends FakePlayerEIO {
        public Target() {
            super(TileAttractor.this.func_145831_w(), TileAttractor.this.getLocation(), new GameProfile(null, ModObject.blockAttractor.getUnlocalisedName() + ":" + TileAttractor.this.getLocation()));
            this.field_70163_u += 1.0;
        }
    }
}

