/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.aversion;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.aversion.AversionObeliskController;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeEntity;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileAversionObelisk
extends AbstractPowerConsumerEntity
implements IRanged {
    private boolean registered = false;
    private AxisAlignedBB bounds;
    private boolean showingRange;

    public TileAversionObelisk() {
        super(new SlotDefinition(12, 0), CapacitorKey.AVERSION_POWER_INTAKE, CapacitorKey.AVERSION_POWER_BUFFER, CapacitorKey.AVERSION_POWER_USE);
    }

    @Override
    public World getRangeWorldObj() {
        return this.func_145831_w();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.field_145850_b.func_72838_d((Entity)new RangeEntity(this));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        AversionObeliskController.instance.deregisterGuard(this);
        this.registered = false;
    }

    @Override
    public float getRange() {
        return CapacitorKey.AVERSION_RANGE.getFloat(this.getCapacitorData());
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.bounds = null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSpawnGuard.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        return CapturedMob.containsSoul(itemstack);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (this.bounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            bb = bb.scale(this.getRange() + 0.5f, this.getRange() + 0.5f, this.getRange() + 0.5f).translate(0.5f, 0.5f, 0.5f);
            this.bounds = new AxisAlignedBB((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        }
        if (redstoneCheck && this.hasPower()) {
            if (!this.registered) {
                AversionObeliskController.instance.registerGuard(this);
                this.registered = true;
            }
            this.usePower();
        }
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    public boolean isSpawnPrevented(EntityLivingBase mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInRange(mob) && this.isMobInFilter(mob);
    }

    private boolean isMobInRange(EntityLivingBase mob) {
        if (mob == null || this.bounds == null) {
            return false;
        }
        return this.bounds.func_72318_a(new Vec3(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v));
    }

    private boolean isMobInFilter(EntityLivingBase entity) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.inventory[i]);
            if (mob == null || !mob.isSameType((Entity)entity)) continue;
            return true;
        }
        return false;
    }
}

