/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.machine.obelisk.render.ObeliskRenderManager;
import crazypants.enderio.render.TextureRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class ObeliskModelQuads {
    private static final float WIDE_PINCH = 0.9f;
    private static final float WIDTH = 0.50624996f;
    private static final float HEIGHT = 0.475f;
    private static final int BOTTOM = EnumFacing.DOWN.ordinal();
    private static final int TOP = EnumFacing.UP.ordinal();
    private static final BoundingBox bb1 = BoundingBox.UNIT_CUBE.scale(0.50624996f, 0.475f, 1.0f).translate(0.0f, -0.2625f, 0.0f);
    private static final BoundingBox bb2 = BoundingBox.UNIT_CUBE.scale(1.0f, 0.475f, 0.50624996f).translate(0.0f, -0.2625f, 0.0f);
    public static final ObeliskModelQuads INSTANCE_ACTIVE = new ObeliskModelQuads(true);
    public static final ObeliskModelQuads INSTANCE = new ObeliskModelQuads(false);
    private List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private static final VertXForm2x xform2x = new VertXForm2x();
    private static final VertXForm2z xform2z = new VertXForm2z();
    private static final VertXForm3 xform3 = new VertXForm3();
    private boolean isActive;

    public ObeliskModelQuads(boolean isActive) {
        this.isActive = isActive;
    }

    public List<BakedQuad> getQuads() {
        if (this.quads.isEmpty()) {
            this.quads = ObeliskModelQuads.createQuads(this.isActive);
        }
        return this.quads;
    }

    public void invalidate() {
        this.quads = new ArrayList<BakedQuad>();
    }

    private static List<BakedQuad> createQuads(boolean isActive) {
        int i;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        TextureRegistry.TextureSupplier[] texs = isActive ? ObeliskRenderManager.INSTANCE.getActiveTextures() : ObeliskRenderManager.INSTANCE.getTextures();
        TextureAtlasSprite[] icons = new TextureAtlasSprite[6];
        for (int i2 = 0; i2 < icons.length; ++i2) {
            icons[i2] = texs[i2].get(TextureAtlasSprite.class);
        }
        TextureAtlasSprite[] bottomIcons = new TextureAtlasSprite[6];
        for (i = 1; i < bottomIcons.length; ++i) {
            bottomIcons[i] = IconUtil.instance.blankTexture;
        }
        bottomIcons[ObeliskModelQuads.BOTTOM] = icons[BOTTOM];
        icons[ObeliskModelQuads.BOTTOM] = IconUtil.instance.blankTexture;
        i = 0;
        for (EnumFacing face : EnumFacing.values()) {
            RenderUtil.addBakedQuadForFace(quads, (BoundingBox)bb1, (TextureAtlasSprite)icons[i], (EnumFacing)face, (VertexTransform)xform2z);
            ++i;
        }
        icons[ObeliskModelQuads.TOP] = IconUtil.instance.blankTexture;
        i = 0;
        for (EnumFacing face : EnumFacing.values()) {
            RenderUtil.addBakedQuadForFace(quads, (BoundingBox)bb2, (TextureAtlasSprite)icons[i], (EnumFacing)face, (VertexTransform)xform2x);
            ++i;
        }
        i = 0;
        for (EnumFacing face : EnumFacing.values()) {
            RenderUtil.addBakedQuadForFace(quads, (BoundingBox)BoundingBox.UNIT_CUBE, (TextureAtlasSprite)bottomIcons[i], (EnumFacing)face, (VertexTransform)xform3);
            ++i;
        }
        return quads;
    }

    private static class VertXForm3
    implements VertexTransform {
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            vec.x -= 0.5;
            vec.x *= (double)0.9f;
            vec.x += 0.5;
            vec.z -= 0.5;
            vec.z *= (double)0.9f;
            vec.z += 0.5;
        }

        public void applyToNormal(Vector3f vec) {
        }
    }

    private static class VertXForm2z
    implements VertexTransform {
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            double pinch = 0.9f;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            vec.z -= 0.5;
            vec.z *= pinch;
            vec.z += 0.5;
        }

        public void applyToNormal(Vector3f vec) {
        }
    }

    private static class VertXForm2x
    implements VertexTransform {
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            double pinch = 0.9f;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            vec.x -= 0.5;
            vec.x *= pinch;
            vec.x += 0.5;
        }

        public void applyToNormal(Vector3f vec) {
        }
    }
}

