/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.sagmill;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machine.sagmill.GuiSagMill;
import crazypants.enderio.machine.sagmill.PacketGrindingBall;
import crazypants.enderio.machine.sagmill.TileSagMill;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class BlockSagMill
extends AbstractMachineBlock<TileSagMill>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockSagMill create() {
        PacketHandler.INSTANCE.registerMessage(PacketGrindingBall.class, PacketGrindingBall.class, PacketHandler.nextID(), Side.CLIENT);
        BlockSagMill res = new BlockSagMill();
        res.init();
        return res;
    }

    private BlockSagMill() {
        super(ModObject.blockSagMill, TileSagMill.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileSagMill) {
            return new ContainerSagMill(player.field_71071_by, (TileSagMill)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileSagMill) {
            return new GuiSagMill(player.field_71071_by, (TileSagMill)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 6;
    }

    @Override
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        TileSagMill te = (TileSagMill)world.func_175625_s(pos);
        if (te != null && te.isActive()) {
            EnumFacing front = te.facing;
            for (int i = 0; i < 3; ++i) {
                double px = (double)pos.func_177958_n() + 0.5 + (double)front.func_82601_c() * 0.51;
                double pz = (double)pos.func_177952_p() + 0.5 + (double)front.func_82599_e() * 0.51;
                double py = (float)pos.func_177956_o() + world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == EnumFacing.NORTH || front == EnumFacing.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vz += front == EnumFacing.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vx += front == EnumFacing.WEST ? -v : v;
                }
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, vx, 0.0, vz, new int[0]);
            }
        }
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileSagMill tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

