/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.solar.SolarType;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class SolarPanelNetwork {
    private Set<BlockPos> panels = new HashSet<BlockPos>();
    private World world = null;
    private boolean valid = false;
    private int energyMaxPerTick = 0;
    private int energyAvailablePerTick = 0;
    private int energyAvailableThisTick = 0;
    private long lastTick = -1L;
    private long nextCollectTick = Long.MAX_VALUE;
    private int rfMax = -1;

    public SolarPanelNetwork() {
        this((World)null);
    }

    public SolarPanelNetwork(World world) {
        this.world = world;
    }

    public SolarPanelNetwork(TileEntitySolarPanel panel) {
        this.world = panel.func_145831_w();
        this.valid = true;
    }

    void onUpdate(TileEntitySolarPanel panel, boolean force) {
        if (this.valid && (force || !this.contains(panel))) {
            this.panels.add(panel.func_174877_v().getImmutable());
            this.nextCollectTick = Long.MAX_VALUE;
            this.cleanupMemberlist();
        }
    }

    boolean contains(TileEntitySolarPanel panel) {
        if (this.world == null) {
            this.world = panel.func_145831_w();
        }
        return this.panels.contains(panel.func_174877_v().getImmutable());
    }

    void cleanupMemberlist() {
        if (!this.panels.isEmpty()) {
            Iterator<BlockPos> iterator = this.panels.iterator();
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            while (iterator.hasNext()) {
                TileEntity tileEntity;
                BlockPos panel = iterator.next();
                if (this.world.func_175667_e(panel) && (tileEntity = this.world.func_175625_s(panel)) instanceof TileEntitySolarPanel && !tileEntity.func_145837_r() && tileEntity.func_145830_o() && ((TileEntitySolarPanel)tileEntity).network == this) {
                    for (EnumFacing neighborDir : EnumFacing.Plane.HORIZONTAL) {
                        BlockPos neighbor = panel.func_177972_a(neighborDir);
                        if (this.panels.contains(neighbor) || !this.world.func_175667_e(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                    continue;
                }
                iterator.remove();
            }
            while (!candidates.isEmpty()) {
                ArrayList candidateList = new ArrayList(candidates);
                for (BlockPos candidate : candidateList) {
                    TileEntity tileEntity;
                    if (!this.panels.contains(candidate) && this.canConnect(candidate) && (tileEntity = this.world.func_175625_s(candidate)) instanceof TileEntitySolarPanel && !tileEntity.func_145837_r() && tileEntity.func_145830_o()) {
                        this.panels.add(candidate.getImmutable());
                        SolarPanelNetwork otherNetwork = ((TileEntitySolarPanel)tileEntity).network;
                        if (otherNetwork != this) {
                            ((TileEntitySolarPanel)tileEntity).setNetwork(this);
                            for (BlockPos other : otherNetwork.panels) {
                                if (this.panels.contains(other) || !this.world.func_175667_e(other)) continue;
                                candidates.add(other);
                            }
                            otherNetwork.destroyNetwork();
                            for (EnumFacing neighborDir : EnumFacing.Plane.HORIZONTAL) {
                                BlockPos neighbor = candidate.func_177972_a(neighborDir);
                                if (this.panels.contains(neighbor) || !this.world.func_175667_e(neighbor)) continue;
                                candidates.add(neighbor);
                            }
                        }
                    }
                    candidates.remove(candidate);
                }
            }
        }
    }

    private boolean canConnect(BlockPos other) {
        if (Config.photovoltaicCanTypesJoins || this.panels.isEmpty()) {
            return true;
        }
        SolarType otherType = null;
        IBlockState otherState = this.world.func_180495_p(other);
        if (otherState.func_177230_c() == EnderIO.blockSolarPanel) {
            otherType = (SolarType)((Object)otherState.func_177229_b(SolarType.KIND));
        }
        for (BlockPos panel : this.panels) {
            IBlockState state;
            if (!this.world.func_175667_e(panel) || (state = this.world.func_180495_p(panel)).func_177230_c() != EnderIO.blockSolarPanel) continue;
            return state.func_177229_b(SolarType.KIND) == otherType;
        }
        return false;
    }

    void destroyNetwork() {
        for (BlockPos panel : this.panels) {
            TileEntity tileEntity;
            if (!this.world.func_175667_e(panel) || !((tileEntity = this.world.func_175625_s(panel)) instanceof TileEntitySolarPanel) || ((TileEntitySolarPanel)tileEntity).network != this) continue;
            ((TileEntitySolarPanel)tileEntity).setNetwork(new SolarPanelNetwork(this.world));
        }
        this.panels.clear();
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void updateEnergy() {
        long tick = EnderIO.proxy.getTickCount();
        if (tick != this.lastTick && this.world != null) {
            this.lastTick = tick;
            if (tick < this.nextCollectTick) {
                this.nextCollectTick = tick + (long)Config.photovoltaicRecalcSunTick;
                this.energyAvailablePerTick = 0;
                this.energyMaxPerTick = 0;
                float lightRatio = TileEntitySolarPanel.calculateLightRatio(this.world);
                for (BlockPos panel : this.panels) {
                    TileEntity tileEntity;
                    if (!this.world.func_175667_e(panel) || !((tileEntity = this.world.func_175625_s(panel)) instanceof TileEntitySolarPanel)) continue;
                    if (this.rfMax < 0 || Config.photovoltaicCanTypesJoins) {
                        this.rfMax = ((TileEntitySolarPanel)tileEntity).getEnergyPerTick();
                    }
                    this.energyMaxPerTick += this.rfMax;
                    if (!((TileEntitySolarPanel)tileEntity).canSeeSun()) continue;
                    this.energyAvailablePerTick = (int)((float)this.energyAvailablePerTick + (float)this.rfMax * lightRatio);
                }
            }
            this.energyAvailableThisTick = this.energyAvailablePerTick;
        }
    }

    public void extractEnergy(int maxExtract) {
        this.energyAvailableThisTick = Math.max(this.energyAvailableThisTick - maxExtract, 0);
    }

    public int getEnergyAvailableThisTick() {
        this.updateEnergy();
        return this.energyAvailableThisTick;
    }

    public int getEnergyAvailablePerTick() {
        this.updateEnergy();
        return this.energyAvailablePerTick;
    }

    public int getEnergyMaxPerTick() {
        this.updateEnergy();
        return this.energyMaxPerTick;
    }
}

