/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import crazypants.enderio.config.Config;
import java.util.Locale;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public enum SolarType implements IStringSerializable
{
    SIMPLE(""),
    ADVANCED(".advanced"),
    VIBRANT(".vibrant");

    public static final PropertyEnum<SolarType> KIND;
    private final String unlocalisedName;

    private SolarType(String unlocalisedName) {
        this.unlocalisedName = unlocalisedName;
    }

    public boolean connectTo(SolarType other) {
        return this == other;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static SolarType getTypeFromMeta(int meta) {
        return SolarType.values()[meta >= 0 && meta < SolarType.values().length ? meta : 0];
    }

    public static int getMetaFromType(SolarType fusedQuartzType) {
        return fusedQuartzType.ordinal();
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public int getRfperTick() {
        switch (this) {
            case ADVANCED: {
                return Config.maxPhotovoltaicAdvancedOutputRF;
            }
            case SIMPLE: {
                return Config.maxPhotovoltaicOutputRF;
            }
            case VIBRANT: {
                return Config.maxPhotovoltaicVibrantOutputRF;
            }
        }
        return 0;
    }

    static {
        KIND = PropertyEnum.func_177709_a((String)"kind", SolarType.class);
    }
}

