/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.machine.ItemTankHelper;
import crazypants.enderio.tool.SmartTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockItemTank
extends ItemBlock
implements IAdvancedTooltipProvider,
IFluidContainerItem {
    public BlockItemTank() {
        super((Block)EnderIO.blockTank);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(EnderIOTab.tabEnderIO);
    }

    public BlockItemTank(Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77637_a(EnderIOTab.tabEnderIO);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int meta = par1ItemStack.func_77952_i();
        String result = super.func_77667_c(par1ItemStack);
        if (meta == 1) {
            result = result + ".advanced";
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        par3List.add(stack);
        stack = new ItemStack((Item)this, 1, 1);
        par3List.add(stack);
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        EnderIO.blockTank.addCommonEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        EnderIO.blockTank.addBasicEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        EnderIO.blockTank.addDetailedEntries(itemstack, entityplayer, list, flag);
    }

    private SmartTank loadTank(ItemStack stack) {
        SmartTank tank;
        if (stack.func_77942_o() && (tank = ItemTankHelper.getTank(stack)) != null) {
            return tank;
        }
        return stack.func_77960_j() == 0 ? new SmartTank(16000) : new SmartTank(32000);
    }

    private void saveTank(ItemStack stack, SmartTank tank) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ItemTankHelper.setTank(stack, tank);
    }

    public FluidStack getFluid(ItemStack container) {
        return this.loadTank(container).getFluid();
    }

    public int getCapacity(ItemStack container) {
        return this.loadTank(container).getCapacity();
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        SmartTank tank = this.loadTank(container);
        int ret = tank.fill(resource, doFill);
        this.saveTank(container, tank);
        return ret;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        SmartTank tank = this.loadTank(container);
        FluidStack ret = tank.drain(maxDrain, doDrain);
        this.saveTank(container, tank);
        return ret;
    }
}

