/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.machine.vacuum.ContainerVacuumChest;
import crazypants.enderio.machine.vacuum.GuiVacuumChest;
import crazypants.enderio.machine.vacuum.PacketVaccumChest;
import crazypants.enderio.machine.vacuum.TileVacuumChest;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.teleport.telepad.TelepadRenderMapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVacuumChest
extends BlockEio<TileVacuumChest>
implements IGuiHandler,
IResourceTooltipProvider,
IRedstoneConnectable,
ISmartRenderAwareBlock,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockVacuumChest create() {
        PacketHandler.INSTANCE.registerMessage(PacketVaccumChest.class, PacketVaccumChest.class, PacketHandler.nextID(), Side.SERVER);
        BlockVacuumChest res = new BlockVacuumChest();
        res.init();
        return res;
    }

    protected BlockVacuumChest() {
        super(ModObject.blockVacuumChest.getUnlocalisedName(), TileVacuumChest.class);
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return true;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity ent = world.func_175625_s(pos);
        if (ent instanceof TileVacuumChest) {
            ((TileVacuumChest)ent).onNeighborBlockChange(neighborBlock);
        }
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(89, this);
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
            TileVacuumChest tileEntity = (TileVacuumChest)this.getTileEntity(world, pos);
            if (tileEntity != null) {
                this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileVacuumChest tileEntity) {
        blockStateWrapper.addCacheKey(0);
    }

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelepadRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelepadRenderMapper.instance;
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 89, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable TileVacuumChest te, ItemStack drop) {
        drop.func_77982_d(new NBTTagCompound());
        if (te != null) {
            te.writeContentsToNBT(drop.func_77978_p());
        }
        PainterUtil2.setSourceBlock(drop, this.getPaintSource(null, world, pos));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (stack != null && stack.func_77978_p() != null && te instanceof TileVacuumChest) {
                ((TileVacuumChest)te).readContentsFromNBT(stack.func_77978_p());
                ((TileVacuumChest)te).setPaintSource(PainterUtil2.getSourceBlock(stack));
                world.func_175689_h(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileVacuumChest) {
            return new ContainerVacuumChest(player, player.field_71071_by, (TileVacuumChest)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileVacuumChest) {
            return new GuiVacuumChest(player, player.field_71071_by, (TileVacuumChest)te);
        }
        return null;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    @Override
    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPaintSource(this.func_176223_P(), world, pos);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        TileVacuumChest te = (TileVacuumChest)this.getTileEntity(world, pos);
        if (te != null) {
            te.setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileVacuumChest te = (TileVacuumChest)this.getTileEntity(world, pos);
        if (te != null) {
            return te.getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState paintSource = this.getPaintSource(worldIn.func_180495_p(pos), worldIn, pos);
        if (paintSource != null) {
            try {
                return paintSource.func_177230_c().func_180662_a(worldIn, pos, renderPass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }
}

