/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.PacketVatProgress;
import crazypants.enderio.machine.vat.VatRecipeManager;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileVat
extends AbstractPoweredTaskEntity
implements IFluidHandler,
ITankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    final SmartTank inputTank = new SmartTank(8000);
    @Store
    final SmartTank outputTank = new SmartTank(8000);
    private static int IO_MB_TICK = 100;
    boolean tanksDirty = false;
    Fluid currentTaskInputFluid;
    Fluid currentTaskOutputFluid;

    public TileVat() {
        super(new SlotDefinition(0, 1, -1, -1, -1, -1), ModObject.blockVat);
    }

    @Override
    public String func_70005_c_() {
        return ModObject.blockVat.getUnlocalisedName();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockVat.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        MachineRecipeInput[] inputs = this.getRecipeInputs();
        inputs[i] = new MachineRecipeInput(i, itemstack);
        return VatRecipeManager.getInstance().isValidInput(inputs);
    }

    @Override
    protected boolean doPush(EnumFacing dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir)) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.outputTank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && target.canFill(dir.func_176734_d(), this.outputTank.getFluid().getFluid())) {
            FluidStack push = this.outputTank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.func_176734_d(), push, true);
            if (filled > 0) {
                this.outputTank.drain(filled, true);
                this.tanksDirty = true;
                return res;
            }
        }
        return res;
    }

    @Override
    protected boolean doPull(EnumFacing dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir)) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.inputTank.getFluidAmount() < this.inputTank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null) {
            if (this.inputTank.getFluidAmount() > 0) {
                FluidStack canPull = this.inputTank.getFluid().copy();
                canPull.amount = this.inputTank.getCapacity() - this.inputTank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.func_176734_d(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.inputTank.fill(drained, true);
                    this.tanksDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.func_176734_d());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.func_176734_d(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.inputTank.fill(drained, true);
                        this.tanksDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.isSideDisabled(from)) {
            return 0;
        }
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int res = this.inputTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.isSideDisabled(from)) {
            return null;
        }
        if (this.outputTank.getFluid() == null || resource == null || !resource.isFluidEqual(this.outputTank.getFluid())) {
            return null;
        }
        FluidStack res = this.outputTank.drain(resource.amount, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.isSideDisabled(from)) {
            return null;
        }
        FluidStack res = this.outputTank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tanksDirty = true;
        }
        return res;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketTanks(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    protected void sendTaskProgressPacket() {
        PacketHandler.sendToAllAround((IMessage)new PacketVatProgress(this), (TileEntity)this);
        this.ticksSinceLastProgressUpdate = 0;
    }

    @Override
    protected void mergeFluidResult(IMachineRecipe.ResultStack result) {
        this.outputTank.fill(result.fluid, true);
        this.tanksDirty = true;
    }

    @Override
    protected void drainInputFluid(MachineRecipeInput fluid) {
        this.inputTank.drain(fluid.fluid.amount, true);
        this.tanksDirty = true;
    }

    @Override
    protected boolean canInsertResultFluid(IMachineRecipe.ResultStack fluid) {
        int res = this.outputTank.fill(fluid.fluid, false);
        return res >= fluid.fluid.amount;
    }

    @Override
    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots() + 1];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length - 1; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        res[res.length - 1] = new MachineRecipeInput(0, this.inputTank.getFluid());
        return res;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.isSideDisabled(from)) {
            return false;
        }
        if (fluid == null || this.inputTank.getFluid() != null && !FluidUtil.areFluidsTheSame((Fluid)this.inputTank.getFluid().getFluid(), (Fluid)fluid)) {
            return false;
        }
        MachineRecipeInput[] inputs = this.getRecipeInputs();
        if (this.inputTank.getFluidAmount() <= 0) {
            inputs[inputs.length - 1] = new MachineRecipeInput(0, new FluidStack(fluid, 1));
        }
        return VatRecipeManager.getInstance().isValidInput(inputs);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.isSideDisabled(from)) {
            return false;
        }
        return this.outputTank.getFluid() != null && FluidUtil.areFluidsTheSame((Fluid)this.outputTank.getFluid().getFluid(), (Fluid)fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.isSideDisabled(from)) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.inputTank.getInfo(), this.outputTank.getInfo()};
    }

    @Override
    public int getPowerUsePerTick() {
        return Config.vatPowerUserPerTickRF;
    }

    @Override
    public String getSoundName() {
        return "machine.vat";
    }

    @Override
    public float getPitch() {
        return 0.3f;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.3f;
    }

    void setClientTask(IPoweredTask currentTask) {
        this.currentTask = currentTask;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.inputTank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.outputTank};
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }
}

