/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint.render;

import com.google.common.base.Function;
import crazypants.enderio.Log;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class PaintRegistry {
    public static IModelState OVERLAY_TRANSFORMATION;
    public static IModelState OVERLAY_TRANSFORMATION2;
    public static IModelState OVERLAY_TRANSFORMATION3;
    public static IModelState OVERLAY_TRANSFORMATION4;
    private static PaintRegistryServer instance;

    public static void create() {
        if (instance == null) {
            instance = new PaintRegistryClient();
            instance.init();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    public static void registerModel(String name, ResourceLocation location) {
        PaintRegistry.registerModel(name, location, PaintMode.TAGGED_TEXTURES);
    }

    public static void registerModel(String name, ResourceLocation location, PaintMode paintMode) {
        PaintRegistry.create();
        instance.registerModel(name, location, paintMode);
    }

    public static <T> T getModel(Class<T> clazz, String name, @Nullable IBlockState paintSource, IModelState rotation) {
        return instance.getModel(clazz, name, paintSource, rotation);
    }

    static {
        instance = null;
    }

    public static class EIOUVLock
    extends ModelLoader.UVLock {
        public EIOUVLock(IModelState parent) {
            super(parent);
        }

        public static IModelState rewrap(IModelState state) {
            if (state instanceof ModelLoader.UVLock && !(state instanceof EIOUVLock)) {
                return new EIOUVLock(((ModelLoader.UVLock)state).getParent());
            }
            return state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + 1231;
            result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            EIOUVLock other = (EIOUVLock)((Object)obj);
            return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
        }
    }

    private static class PaintRegistryClient
    extends PaintRegistryServer {
        @SideOnly(value=Side.CLIENT)
        private ConcurrentMap<String, Pair<ResourceLocation, PaintMode>> modelLocations;
        @SideOnly(value=Side.CLIENT)
        private ConcurrentMap<String, IModel> models;
        @SideOnly(value=Side.CLIENT)
        private ConcurrentMap<String, ConcurrentMap<Pair<IBlockState, IModelState>, IBakedModel>> cache;

        private PaintRegistryClient() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void init() {
            this.modelLocations = new ConcurrentHashMap<String, Pair<ResourceLocation, PaintMode>>();
            this.models = new ConcurrentHashMap<String, IModel>();
            this.cache = new ConcurrentHashMap<String, ConcurrentMap<Pair<IBlockState, IModelState>, IBakedModel>>();
            this.modelLocations.put("_missing", (Pair<ResourceLocation, PaintMode>)Pair.of((Object)null, (Object)((Object)PaintMode.ALL_TEXTURES)));
            OVERLAY_TRANSFORMATION = new TRSRTransformation(new Vector3f(0.01f, 0.01f, 0.01f), null, null, null);
            OVERLAY_TRANSFORMATION2 = new TRSRTransformation(new Vector3f(-0.01f, -0.01f, -0.01f), null, new Vector3f(1.02f, 1.02f, 1.02f), null);
            OVERLAY_TRANSFORMATION3 = new TRSRTransformation(new Vector3f(-0.01f, -0.01f, -0.01f), null, new Vector3f(1.02f, 1.04f, 1.02f), null);
            OVERLAY_TRANSFORMATION4 = new TRSRTransformation(new Vector3f(-0.0105f, -0.0095f, -0.01f), null, new Vector3f(1.02f, 1.02f, 1.02f), null);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerModel(String name, ResourceLocation location, PaintMode paintMode) {
            this.modelLocations.put(name, (Pair<ResourceLocation, PaintMode>)Pair.of((Object)location, (Object)((Object)paintMode)));
            this.models.remove(name);
            this.cache.remove(name);
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void bakeModels(ModelBakeEvent event) {
            this.cache.clear();
            for (Map.Entry entry : this.modelLocations.entrySet()) {
                try {
                    ResourceLocation resourceLocation = (ResourceLocation)((Pair)entry.getValue()).getLeft();
                    if (resourceLocation != null) {
                        IModel model = event.modelLoader.getModel(resourceLocation);
                        this.models.put((String)entry.getKey(), model);
                        continue;
                    }
                    this.models.put((String)entry.getKey(), event.modelLoader.getMissingModel());
                }
                catch (IOException e) {
                    Log.warn("Model '" + entry.getValue() + "' failed to load: " + e);
                }
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public <T> T getModel(Class<T> clazz, String name, @Nullable IBlockState paintSource, IModelState rotationIn) {
            Pair key;
            ConcurrentMap subcache;
            IBakedModel bakedModel;
            IModelState rotation = EIOUVLock.rewrap(rotationIn);
            if (!this.cache.containsKey(name)) {
                this.cache.put(name, new ConcurrentHashMap());
            }
            if ((bakedModel = (IBakedModel)(subcache = (ConcurrentMap)this.cache.get(name)).get(key = Pair.of((Object)paintSource, (Object)rotation))) == null) {
                IModel sourceModel = (IModel)this.models.get(name);
                if (sourceModel == null) {
                    sourceModel = (IModel)this.models.get("_missing");
                }
                if (sourceModel != null) {
                    bakedModel = this.paintModel(sourceModel, paintSource, rotation, this.getPaintMode(name));
                }
                if (bakedModel == null) {
                    bakedModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
                }
                subcache.putIfAbsent(key, bakedModel);
                this.checkCache(name, subcache);
            }
            return clazz.isInstance(bakedModel) ? (T)clazz.cast(bakedModel) : null;
        }

        private void checkCache(String name, ConcurrentMap<Pair<IBlockState, IModelState>, IBakedModel> cache1) {
            if (cache1.size() > 200) {
                Log.warn("Cache for " + name + " is at " + cache1.size() + " objects. Cleaning it...");
                cache1.clear();
            }
        }

        @SideOnly(value=Side.CLIENT)
        private PaintMode getPaintMode(String name) {
            Pair pair = (Pair)this.modelLocations.get(name);
            return pair == null ? null : (PaintMode)((Object)pair.getRight());
        }

        @SideOnly(value=Side.CLIENT)
        private IBakedModel paintModel(IModel sourceModel, final @Nullable IBlockState paintSource, IModelState rotation, final PaintMode paintMode) {
            IModelState state = sourceModel.getDefaultState();
            state = this.combine(state, rotation);
            return sourceModel.bake(state, Attributes.DEFAULT_BAKED_FORMAT, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(@Nullable ResourceLocation location) {
                    String locationString = location.toString();
                    if (paintMode != PaintMode.TAGGED_TEXTURES || locationString.endsWith("PAINT")) {
                        if (paintSource == null) {
                            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
                        }
                        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(paintSource);
                    }
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(locationString);
                }

                public boolean equals(@Nullable Object obj) {
                    return super.equals(obj);
                }
            });
        }

        @SideOnly(value=Side.CLIENT)
        private IModelState combine(IModelState a, IModelState b) {
            boolean isUVlocked = false;
            if (a instanceof ModelLoader.UVLock) {
                isUVlocked = true;
                a = ((ModelLoader.UVLock)a).getParent();
            }
            if (b instanceof ModelLoader.UVLock) {
                isUVlocked = true;
                b = ((ModelLoader.UVLock)b).getParent();
            }
            Object result = a == null && b == null ? ModelRotation.X0_Y0 : (a == null ? b : (b == null ? a : new ModelStateComposition(a, b)));
            if (isUVlocked) {
                result = new ModelLoader.UVLock((IModelState)result);
            }
            return result;
        }
    }

    private static class PaintRegistryServer {
        private PaintRegistryServer() {
        }

        protected void init() {
        }

        public void registerModel(String name, ResourceLocation location, PaintMode paintMode) {
        }

        public <T> T getModel(Class<T> clazz, String name, @Nullable IBlockState paintSource, IModelState rotation) {
            return null;
        }
    }

    public static enum PaintMode {
        ALL_TEXTURES,
        TAGGED_TEXTURES;

    }
}

