/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint.render;

import com.enderio.core.common.util.IBlockAccessWrapper;
import crazypants.enderio.paint.IPaintable;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class PaintedBlockAccessWrapper
extends IBlockAccessWrapper {
    private static final ConcurrentHashMap<Block, Boolean> teBlackList = new ConcurrentHashMap();
    private final boolean fakeTe;

    public PaintedBlockAccessWrapper(IBlockAccess ba, boolean fakeTe) {
        super(ba);
        this.fakeTe = fakeTe;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource.func_177230_c().isSideSolid((IBlockAccess)this, pos, side);
        }
        return super.isSideSolid(pos, side, _default);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return this.createTileEntity(paintSource, pos);
        }
        return super.func_175625_s(pos);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource;
        }
        return super.func_180495_p(pos);
    }

    private IBlockState getPaintSource(BlockPos pos) {
        IBlockState state = super.func_180495_p(pos);
        if (state.func_177230_c() instanceof IPaintable.IBlockPaintableBlock) {
            return ((IPaintable.IBlockPaintableBlock)state.func_177230_c()).getPaintSource(state, this.wrapped, pos);
        }
        return null;
    }

    private TileEntity createTileEntity(IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (!this.fakeTe || !block.hasTileEntity(state) || teBlackList.containsKey(block)) {
            return null;
        }
        try {
            TileEntity tileEntity = block.createTileEntity(null, state);
            tileEntity.func_174878_a(pos);
            return tileEntity;
        }
        catch (Throwable t) {
            teBlackList.put(block, true);
            return null;
        }
    }
}

