/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PowerDistributor {
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private final BlockCoord bc;

    public PowerDistributor(BlockCoord bc) {
        this.bc = bc;
    }

    public void neighboursChanged() {
        this.receptorsDirty = true;
    }

    public int transmitEnergy(World worldObj, int available) {
        int transmitted = 0;
        this.checkReceptors(worldObj);
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && available > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            if (pp != null && pp.getMinEnergyReceived(receptor.fromDir.func_176734_d()) <= available) {
                int used = pp.recieveEnergy(receptor.fromDir.func_176734_d(), available);
                transmitted += used;
                available -= used;
            }
            if (available <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        return transmitted;
    }

    private void checkReceptors(World worldObj) {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockCoord checkLoc;
            TileEntity te;
            IPowerInterface pi;
            TileEntity transmitter = worldObj.func_175625_s(this.bc.getBlockPos());
            if (transmitter instanceof AbstractMachineEntity && !((AbstractMachineEntity)transmitter).getIoMode(dir).canOutput() || (pi = PowerHandlerUtil.create(te = worldObj.func_175625_s((checkLoc = this.bc.getLocation(dir)).getBlockPos()))) == null || !pi.canConduitConnect(dir.func_176734_d())) continue;
            this.receptors.add(new Receptor(pi, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    static class Receptor {
        IPowerInterface receptor;
        EnumFacing fromDir;

        private Receptor(IPowerInterface rec, EnumFacing fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

