/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class HalfBakedQuad {
    private final List<Vertex> corners;
    private final TextureAtlasSprite tex;
    private final Vector4f color;
    private static final Vector4f NO_COLOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    boolean use = true;

    public HalfBakedQuad(BoundingBox bb, EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color) {
        this.corners = bb.getCornersWithUvForFace(face, umin, umax, vmin, vmax);
        this.tex = tex;
        this.color = color != null ? color : NO_COLOR;
    }

    private static void addBakedQuads(List<BakedQuad> quads, Collection<Vertex> vertices, TextureAtlasSprite tex, Vector4f color) {
        UnpackedBakedQuad.Builder builder = null;
        Iterator<Vertex> it = vertices.iterator();
        while (it.hasNext()) {
            EnumFacing face = null;
            for (int i = 0; i < 4; ++i) {
                Vertex v = it.next();
                if (i == 0) {
                    face = EnumFacing.func_176737_a((float)v.nx(), (float)v.ny(), (float)v.nz());
                    builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
                    builder.setQuadOrientation(face);
                    builder.setQuadColored();
                }
                v.color = color;
                HalfBakedQuad.putVertexData(builder, v, face.func_176730_m(), tex);
            }
            quads.add((BakedQuad)builder.build());
        }
    }

    private static void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, Vec3i normal, TextureAtlasSprite sprite) {
        if (sprite == null) {
            sprite = IconUtil.instance.errorTexture;
        }
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)v.x(), (float)v.y(), (float)v.z(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = v.normal != null ? LightUtil.diffuseLight((float)v.normal.x, (float)v.normal.y, (float)v.normal.z) : LightUtil.diffuseLight((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
                    if (v.color != null) {
                        builder.put(e, new float[]{d * v.color.x, d * v.color.y, d * v.color.z, v.color.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{d, d, d, 1.0f});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.u() * 16.0f)), sprite.func_94207_b((double)(v.v() * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (v.normal != null) {
                        builder.put(e, new float[]{v.nx(), v.ny(), v.nz(), 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public void bake(List<BakedQuad> quads) {
        if (this.use) {
            HalfBakedQuad.addBakedQuads(quads, this.corners, this.tex, this.color);
        } else {
            RenderUtil.addBakedQuads(quads, this.corners, (TextureAtlasSprite)this.tex, (Vector4f)this.color);
        }
    }

    public void transform(VertexTransform ... xforms) {
        for (Vertex vertex : this.corners) {
            for (VertexTransform xform : xforms) {
                xform.apply(vertex);
            }
        }
    }

    public void render(WorldRenderer tes) {
        for (Vertex v : this.corners) {
            tes.func_181662_b(v.x(), v.y(), v.z()).func_181673_a((double)this.tex.func_94214_a((double)(v.u() * 16.0f)), (double)this.tex.func_94207_b((double)(v.v() * 16.0f))).func_181666_a(this.color.x, this.color.y, this.color.z, this.color.w).func_181663_c(v.nx(), v.ny(), v.nz()).func_181675_d();
        }
    }

    public static class HalfBakedList
    extends AbstractList<HalfBakedQuad> {
        private final List<HalfBakedQuad> store = new ArrayList<HalfBakedQuad>();

        @Override
        public HalfBakedQuad get(int index) {
            return this.store.get(index);
        }

        @Override
        public int size() {
            return this.store.size();
        }

        public void add(BoundingBox bb, EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add(new HalfBakedQuad(bb, face, umin, umax, vmin, vmax, tex, color));
        }

        public void add(BoundingBox bb, EnumFacing face, double umin, double umax, double vmin, double vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add(new HalfBakedQuad(bb, face, (float)umin, (float)umax, (float)vmin, (float)vmax, tex, color));
        }

        public void transform(VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
            }
        }

        public void bake(List<BakedQuad> quads, VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
                halfBakedQuad.bake(quads);
            }
        }

        public void bake(List<BakedQuad> quads) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.bake(quads);
            }
        }

        public void render(WorldRenderer tes) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.render(tes);
            }
        }

        public void render() {
            RenderUtil.bindBlockTexture();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179145_e();
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            WorldRenderer tes = Tessellator.func_178181_a().func_178180_c();
            tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            this.render(tes);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
        }
    }
}

