/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render;

import crazypants.enderio.EnderIOTab;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.OverlayHolder;
import crazypants.enderio.render.pipeline.RelayingBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IRegistry;
import net.minecraft.util.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SmartModelAttacher {
    private static final List<RegistrationHolder> blocks = new ArrayList<RegistrationHolder>();

    public static void register(Block block) {
        SmartModelAttacher.register(block, EnumRenderMode.RENDER, EnumRenderMode.DEFAULTS, EnumRenderMode.AUTO);
    }

    public static void registerNoProps(Block block) {
        SmartModelAttacher.register(block, null, null, null, false);
    }

    public static void registerItemOnly(Block block) {
        SmartModelAttacher.register(block, null, null, null, true);
    }

    public static <T extends Comparable<T>, V extends T> void register(Block block, IProperty<T> property, V defaultsValue, V autoValue) {
        SmartModelAttacher.register(block, property, defaultsValue, autoValue, false);
    }

    private static <T extends Comparable<T>, V extends T> void register(Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
        blocks.add(new RegistrationHolder<T, V>(block, property, defaultsValue, autoValue, itemOnly));
    }

    public static void create() {
        MinecraftForge.EVENT_BUS.register((Object)new SmartModelAttacher());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockItemModels() {
        for (RegistrationHolder holder : blocks) {
            Block block = holder.block;
            Item item = Item.func_150898_a((Block)block);
            if (item == null) continue;
            ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "inventory");
            if (item.func_77614_k()) {
                ArrayList list = new ArrayList();
                item.func_150895_a(item, EnderIOTab.tabNoTab, list);
                for (ItemStack itemStack : list) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemStack.func_77952_i(), (ModelResourceLocation)location);
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        for (RegistrationHolder holder : blocks) {
            ModelResourceLocation itemMrl;
            IBakedModel defaultBakedModel;
            ModelResourceLocation defaultMrl;
            IBlockState defaultState;
            Block block = holder.block;
            Map locations = new DefaultStateMapper().func_178130_a(block);
            if (holder.property != null && block.func_176223_P().func_177227_a().contains(holder.property)) {
                defaultState = block.func_176223_P().func_177226_a(holder.property, holder.defaultsValue);
                defaultMrl = (ModelResourceLocation)locations.get(defaultState);
                defaultBakedModel = (IBakedModel)event.modelRegistry.func_82594_a((Object)defaultMrl);
                if (defaultBakedModel == null) {
                    throw new RuntimeException("Model for state " + defaultState + " failed to load from " + defaultMrl + ". " + SmartModelAttacher.debugOutput((IRegistry<ModelResourceLocation, IBakedModel>)event.modelRegistry, defaultMrl));
                }
                RelayingBakedModel model = new RelayingBakedModel(defaultBakedModel);
                ModelResourceLocation itemMrl2 = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory");
                event.modelRegistry.func_82595_a((Object)itemMrl2, (Object)model);
                for (Map.Entry entry : locations.entrySet()) {
                    if (((IBlockState)entry.getKey()).func_177229_b(holder.property) == holder.autoValue) {
                        event.modelRegistry.func_82595_a(entry.getValue(), (Object)model);
                        continue;
                    }
                    if (event.modelRegistry.func_82594_a(entry.getValue()) != null) continue;
                    event.modelRegistry.func_82595_a(entry.getValue(), (Object)defaultBakedModel);
                }
                continue;
            }
            defaultState = block.func_176223_P();
            defaultMrl = (ModelResourceLocation)locations.get(defaultState);
            defaultBakedModel = (IBakedModel)event.modelRegistry.func_82594_a((Object)defaultMrl);
            if (!holder.itemOnly) {
                for (ModelResourceLocation mrl : locations.values()) {
                    IBakedModel model = (IBakedModel)event.modelRegistry.func_82594_a((Object)mrl);
                    event.modelRegistry.func_82595_a((Object)mrl, (Object)new RelayingBakedModel(model != null ? model : defaultBakedModel));
                }
            }
            if (event.modelRegistry.func_82594_a((Object)(itemMrl = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory"))) != null) continue;
            event.modelRegistry.func_82595_a((Object)itemMrl, (Object)new RelayingBakedModel(defaultBakedModel));
        }
        OverlayHolder.collectOverlayQuads(event);
        BlockStateWrapperBase.invalidate();
    }

    private static String debugOutput(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation defaultMrl) {
        String prefix = defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a();
        if (modelRegistry instanceof RegistrySimple) {
            RegistrySimple rg = (RegistrySimple)modelRegistry;
            StringBuilder sb = new StringBuilder();
            for (Object key : rg.func_148742_b()) {
                if (!key.toString().startsWith(prefix)) continue;
                sb.append(key + "; ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            } else {
                sb.append("(none)");
            }
            return "Loaded states for " + prefix + " are: " + sb.toString();
        }
        return "Loaded states could not be determined because modelRegistry is not a RegistrySimple.";
    }

    private static class RegistrationHolder<T extends Comparable<T>, V extends T> {
        Block block;
        IProperty<T> property;
        V defaultsValue;
        V autoValue;
        boolean itemOnly;

        protected RegistrationHolder(Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
            this.block = block;
            this.property = property;
            this.defaultsValue = defaultsValue;
            this.autoValue = autoValue;
            this.itemOnly = itemOnly;
        }
    }
}

