/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import crazypants.enderio.Log;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.pipeline.CacheKey;
import crazypants.enderio.render.pipeline.CollectedQuadBakedBlockModel;
import crazypants.enderio.render.pipeline.OverlayHolder;
import crazypants.enderio.render.pipeline.PaintWrangler;
import crazypants.enderio.render.pipeline.QuadCollector;
import crazypants.util.Profiler;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateWrapperBase
extends CacheKey
implements IBlockStateWrapper {
    private static final Cache<Pair<Block, Long>, QuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).build();
    @Nonnull
    private final Block block;
    @Nonnull
    private final IBlockState state;
    @Nonnull
    private final IBlockAccess world;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final IRenderMapper.IBlockRenderMapper renderMapper;
    private boolean doCaching = false;
    private IBakedModel model = null;
    @Nonnull
    private static final IRenderMapper.IBlockRenderMapper nullRenderMapper = new IRenderMapper.IBlockRenderMapper(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, EnumWorldBlockLayer blockLayer, QuadCollector quadCollector) {
            return null;
        }
    };

    public BlockStateWrapperBase(IBlockState state, IBlockAccess world, BlockPos pos, IRenderMapper.IBlockRenderMapper renderMapper) {
        this.state = BlockStateWrapperBase.notnull(state);
        this.block = BlockStateWrapperBase.notnull(state.func_177230_c());
        this.world = BlockStateWrapperBase.notnull(world);
        this.pos = BlockStateWrapperBase.notnull(pos);
        this.renderMapper = renderMapper != null ? renderMapper : nullRenderMapper;
    }

    @Nonnull
    private static <X> X notnull(@Nullable X x) {
        if (x == null) {
            throw new NullPointerException();
        }
        return x;
    }

    protected BlockStateWrapperBase(BlockStateWrapperBase parent, IBlockState state) {
        this.block = parent.block;
        this.state = BlockStateWrapperBase.notnull(state);
        this.world = parent.world;
        this.pos = parent.pos;
        this.renderMapper = parent.renderMapper;
        this.doCaching = parent.doCaching;
        this.model = parent.model;
    }

    public static void invalidate() {
        cache.invalidateAll();
    }

    public Collection<IProperty> func_177227_a() {
        return this.state.func_177227_a();
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        return new BlockStateWrapperBase(this, this.state.func_177226_a(property, value));
    }

    public <T extends Comparable<T>> IBlockState func_177231_a(IProperty<T> property) {
        return new BlockStateWrapperBase(this, this.state.func_177231_a(property));
    }

    public ImmutableMap<IProperty, Comparable> func_177228_b() {
        return this.state.func_177228_b();
    }

    @Nonnull
    public Block func_177230_c() {
        return this.block;
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.pos);
    }

    @Override
    @Nonnull
    public IBlockAccess getWorld() {
        return this.world;
    }

    @Override
    @Nonnull
    public IBlockState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public IBlockStateWrapper addCacheKey(@Nullable Object addlCacheKey) {
        super.addCacheKey(addlCacheKey);
        this.doCaching = true;
        return this;
    }

    @Override
    public void bakeModel() {
        String cacheResult;
        long start = Profiler.client.start();
        QuadCollector quads = null;
        IBlockState rawPaintSource = null;
        IBlockState paintSource = null;
        if (!(!(this.block instanceof IPaintable.IBlockPaintableBlock) || this.block instanceof IPaintable.IWrenchHideablePaint && YetaUtil.shouldHeldItemHideFacades())) {
            rawPaintSource = ((IPaintable.IBlockPaintableBlock)this.block).getPaintSource(this.state, this.world, this.pos);
            paintSource = PaintWrangler.getDynamicBlockState(this.world, this.pos, rawPaintSource);
        }
        if (this.doCaching) {
            if (paintSource != null) {
                this.addCacheKeyInternal(paintSource);
            }
            cacheResult = (quads = (QuadCollector)cache.getIfPresent((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()))) == null ? "miss" : "hit";
        } else {
            cacheResult = "not cachable";
        }
        if (quads == null) {
            quads = new QuadCollector();
            if (!this.bakePaintLayer(quads, rawPaintSource, paintSource)) {
                this.bakeBlockLayer(quads);
                paintSource = null;
            } else if (this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware.IPaintAware) {
                this.bakeBlockLayer(quads);
            }
            if (this.doCaching) {
                cache.put((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()), (Object)quads);
            }
        }
        this.model = new CollectedQuadBakedBlockModel(quads.combine(OverlayHolder.getOverlay(this.renderMapper.mapOverlayLayer(this, this.world, this.pos, paintSource != null))));
        Profiler.client.stop(start, this.state.func_177230_c().func_149732_F() + " (bake, cache=" + cacheResult + ")");
    }

    protected void bakeBlockLayer(QuadCollector quads) {
        if (this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware) {
            for (EnumWorldBlockLayer layer : quads.getBlockLayers()) {
                quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
            }
        } else {
            EnumWorldBlockLayer layer = this.block.func_180664_k();
            quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
        }
    }

    protected boolean bakePaintLayer(QuadCollector quads, IBlockState rawPaintSource, IBlockState paintSource) {
        if (paintSource != null) {
            EnumWorldBlockLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
            boolean rendered = true;
            for (EnumWorldBlockLayer layer : quads.getBlockLayers()) {
                if (!paintSource.func_177230_c().canRenderInLayer(layer)) continue;
                ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)layer);
                rendered = rendered && PaintWrangler.wrangleBakedModel(this.world, this.pos, rawPaintSource, paintSource, quads);
            }
            ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)oldRenderLayer);
            return rendered;
        }
        return false;
    }

    protected IBakedModel getModel() {
        if (this.model == null) {
            this.bakeModel();
            if (this.model != null) {
                Log.warn(this.block + " doesn't bake its model!");
            } else {
                Log.warn(this.block + "'s model won't bake!");
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
        }
        return this.model;
    }
}

