/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.dummy.BlockMachineIO;
import crazypants.enderio.render.pipeline.QuadCollector;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;

public class OverlayHolder {
    private static final QuadCollector[][] data = new QuadCollector[EnumFacing.values().length][IOMode.EnumIOMode.values().length];

    public static void collectOverlayQuads(ModelBakeEvent event) {
        Map locations = new DefaultStateMapper().func_178130_a((Block)BlockMachineIO.block);
        for (EnumFacing face : EnumFacing.values()) {
            for (IOMode.EnumIOMode iOMode : IOMode.EnumIOMode.values()) {
                IBlockState state = BlockMachineIO.block.func_176223_P().func_177226_a((IProperty)IOMode.IO, (Comparable)IOMode.get(face, iOMode));
                ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state);
                IBakedModel model = (IBakedModel)event.modelRegistry.func_82594_a((Object)mrl);
                if (model == null) {
                    throw new RuntimeException("Model for state " + state + " failed to load from " + mrl + ".");
                }
                QuadCollector quads = new QuadCollector();
                EnumWorldBlockLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
                EnumWorldBlockLayer layer = BlockMachineIO.block.func_180664_k();
                ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)layer);
                List generalQuads = model.func_177550_a();
                if (generalQuads != null && !generalQuads.isEmpty()) {
                    quads.addQuads(null, layer, generalQuads);
                }
                for (EnumFacing face1 : EnumFacing.values()) {
                    List faceQuads = model.func_177551_a(face);
                    if (faceQuads == null || faceQuads.isEmpty()) continue;
                    quads.addQuads(face1, layer, faceQuads);
                }
                ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)oldRenderLayer);
                OverlayHolder.data[face.ordinal()][iOMode.ordinal()] = quads;
            }
        }
    }

    @Nullable
    public static QuadCollector getOverlay(EnumMap<EnumFacing, IOMode.EnumIOMode> overlay) {
        QuadCollector quads = null;
        if (overlay != null) {
            for (Map.Entry<EnumFacing, IOMode.EnumIOMode> entry : overlay.entrySet()) {
                quads = data[entry.getKey().ordinal()][entry.getValue().ordinal()].combine(quads);
            }
        }
        return quads;
    }
}

