/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import com.google.common.base.Throwables;
import crazypants.enderio.render.pipeline.CompositeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class QuadCollector {
    private final List<BakedQuad>[] table = new List[QuadCollector.mkKey(EnumFacing.values()[EnumFacing.values().length - 1], EnumWorldBlockLayer.values()[EnumWorldBlockLayer.values().length - 1]) + 1];

    private static Integer mkKey(EnumFacing side, EnumWorldBlockLayer pass) {
        return (side == null ? 0 : side.ordinal() + 1) * EnumWorldBlockLayer.values().length + (pass == null ? 0 : pass.ordinal());
    }

    public void addQuads(EnumFacing side, EnumWorldBlockLayer pass, List<BakedQuad> quads) {
        if (quads != null && !quads.isEmpty()) {
            Integer key = QuadCollector.mkKey(side, pass);
            if (this.table[key] == null) {
                this.table[key.intValue()] = new ArrayList<BakedQuad>(quads);
            } else {
                this.table[key].addAll(quads);
            }
        }
    }

    public List<BakedQuad> getQuads(EnumFacing side, EnumWorldBlockLayer pass) {
        Integer key = QuadCollector.mkKey(side, pass);
        if (this.table[key] == null) {
            return Collections.emptyList();
        }
        return this.table[key];
    }

    public void addFriendlyBlockStates(EnumWorldBlockLayer pass, List<IBlockState> states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        for (IBlockState state : states) {
            IBakedModel model = modelShapes.func_178125_b(state);
            List generalQuads = model.func_177550_a();
            if (generalQuads != null && !generalQuads.isEmpty()) {
                this.addQuads(null, pass, generalQuads);
            }
            for (EnumFacing face : EnumFacing.values()) {
                List faceQuads = model.func_177551_a(face);
                if (faceQuads == null || faceQuads.isEmpty()) continue;
                this.addQuads(face, pass, faceQuads);
            }
        }
    }

    public List<String> addUnfriendlybakedModel(EnumWorldBlockLayer pass, IBakedModel model, IBlockState state, long rand) {
        if (model == null) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List generalQuads = model.func_177550_a();
            if (generalQuads != null && !generalQuads.isEmpty()) {
                this.addQuads(null, pass, generalQuads);
            }
        }
        catch (Throwable t) {
            errors.add(Throwables.getStackTraceAsString((Throwable)t));
        }
        for (EnumFacing face : EnumFacing.values()) {
            try {
                List faceQuads = model.func_177551_a(face);
                if (faceQuads == null || faceQuads.isEmpty()) continue;
                this.addQuads(face, pass, faceQuads);
            }
            catch (Throwable t) {
                errors.add(Throwables.getStackTraceAsString((Throwable)t));
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    public void addFriendlybakedModel(EnumWorldBlockLayer pass, IBakedModel model, @Nullable IBlockState state, long rand) {
        if (model != null) {
            EnumWorldBlockLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
            ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)pass);
            List generalQuads = model.func_177550_a();
            if (generalQuads != null && !generalQuads.isEmpty()) {
                this.addQuads(null, pass, generalQuads);
            }
            for (EnumFacing face : EnumFacing.values()) {
                List faceQuads = model.func_177551_a(face);
                if (faceQuads == null || faceQuads.isEmpty()) continue;
                this.addQuads(face, pass, faceQuads);
            }
            ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)oldRenderLayer);
        }
    }

    public Collection<EnumWorldBlockLayer> getBlockLayers() {
        return Arrays.asList(EnumWorldBlockLayer.values());
    }

    public boolean isEmpty() {
        for (List<BakedQuad> entry : this.table) {
            if (entry == null || entry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public QuadCollector combine(@Nullable QuadCollector other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        QuadCollector result = new QuadCollector();
        for (int i = 0; i < this.table.length; ++i) {
            result.table[i] = CompositeList.create(this.table[i], other.table[i]);
        }
        return result;
    }
}

