/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.state;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class GlState {
    public static boolean useDoubleAction = false;
    public static boolean forceAction = true;
    private static final Map<String, State> allStates = new HashMap<String, State>();
    private final Map<String, State> states = new HashMap<String, State>();
    public static final GlState CLEAN_TESR_STATE_COMPLETE;
    public static final GlState CLEAN_TESR_STATE;

    private static void registerState(State state) {
        allStates.put(state.getName(), state);
    }

    void addState(State state) {
        this.states.put(state.getName(), state);
    }

    public List<Object> store() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (State state : this.states.values()) {
            result.add(state.getName());
            state.store(result);
        }
        return result;
    }

    public String toString() {
        List<Object> data = this.store();
        StringBuilder sb = new StringBuilder();
        sb.append("GlState state = GlState.create(");
        for (Object o : data) {
            if (o instanceof String) {
                sb.append("\"");
                sb.append(o);
                sb.append("\", ");
                continue;
            }
            if (o instanceof Float) {
                String s = String.format((Locale)null, "%.12f", o).replaceFirst("(\\.\\d+?)0+$", "$1");
                sb.append(s);
                sb.append("f, ");
                continue;
            }
            sb.append(o);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(");");
        return sb.toString();
    }

    public static GlState create(Object ... data) {
        GlState glstate = new GlState();
        Iterator<Object> iterator = Arrays.asList(data).iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            State state = allStates.get(key);
            if (state == null) {
                throw new RuntimeException("Invalid State data, not a key: " + state);
            }
            try {
                State newState = state.create(iterator);
                glstate.states.put(newState.getName(), newState);
            }
            catch (NoSuchElementException e) {
                throw new RuntimeException("Invalid State data, not enough data for: " + state);
            }
            catch (ClassCastException e1) {
                throw new RuntimeException("Invalid State data, bad data for: " + state + ", got " + e1);
            }
        }
        return glstate;
    }

    public void apply() {
        for (State state : this.states.values()) {
            state.apply();
        }
    }

    public void apply_filtered(GlState filter) {
        for (String stateName : filter.states.keySet()) {
            if (!this.states.containsKey(stateName)) continue;
            this.states.get(stateName).apply();
        }
    }

    static {
        GlState.registerState(new AlphaState(false, 0, 0.0f));
        GlState.registerState(new LightingState(false));
        GlState.registerState(new LightState(new boolean[8]));
        GlState.registerState(new ColorMaterialState(false, 0, 0));
        GlState.registerState(new BlendState(false, 0, 0));
        GlState.registerState(new DepthState(false, false, 0));
        GlState.registerState(new FogState(false, 0, 0.0f, 0.0f, 0.0f));
        GlState.registerState(new CullState(false, 0));
        GlState.registerState(new PolygonOffsetState(false, 0.0f, 0.0f));
        GlState.registerState(new ColorLogicState(false, 0));
        GlState.registerState(new ClearState(0.0, 0.0f, 0.0f, 0.0f, 0.0f));
        GlState.registerState(new NormalizeState(false));
        GlState.registerState(new ShadeModelState(0));
        GlState.registerState(new RescaleNormalState(false));
        GlState.registerState(new ColorMask(false, false, false, false));
        GlState.registerState(new ColorState(0.0f, 0.0f, 0.0f, 0.0f));
        CLEAN_TESR_STATE_COMPLETE = GlState.create("color", Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), "shademodel", 7424, "rescalenormal", false, "blend", true, 770, 771, "colorlogic", false, "clear", 1.0, Float.valueOf(0.70464736f), Float.valueOf(0.8232166f), Float.valueOf(0.9982141f), Float.valueOf(0.0f), "lighting", false, "colormask", true, true, true, true, "depth", true, true, 515, "light", true, true, false, false, false, false, false, false, "cullface", true, 1029, "polygonoffset", false, "alpha", true, 1032, 5634, "normalize", false, "fog", true, 9729, Float.valueOf(1.0f), Float.valueOf(144.0f), Float.valueOf(192.0f));
        CLEAN_TESR_STATE = GlState.create("color", Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), "shademodel", 7424, "blend", true, 770, 771, "lighting", false, "depth", true, true, 515, "cullface", true, 1029, "alpha", true, 1032, 5634);
    }

    protected static class ColorState
    implements State {
        protected final float red;
        protected final float green;
        protected final float blue;
        protected final float alpha;

        @Override
        public String getName() {
            return "color";
        }

        protected ColorState(float red, float green, float blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        @Override
        public void store(List<Object> data) {
            data.add(Float.valueOf(this.red));
            data.add(Float.valueOf(this.green));
            data.add(Float.valueOf(this.blue));
            data.add(Float.valueOf(this.alpha));
        }

        @Override
        public State create(Iterator<Object> data) {
            return new ColorState(((Float)data.next()).floatValue(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue());
        }

        @Override
        public void apply() {
            if (useDoubleAction) {
                GlStateManager.func_179131_c((float)(1.0f - this.red), (float)this.green, (float)this.blue, (float)this.alpha);
            }
            GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
            if (forceAction) {
                GL11.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
            }
        }
    }

    protected static class ColorMask
    implements State {
        protected final boolean red;
        protected final boolean green;
        protected final boolean blue;
        protected final boolean alpha;

        @Override
        public String getName() {
            return "colormask";
        }

        protected ColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.red);
            data.add(this.green);
            data.add(this.blue);
            data.add(this.alpha);
        }

        @Override
        public State create(Iterator<Object> data) {
            return new ColorMask((Boolean)data.next(), (Boolean)data.next(), (Boolean)data.next(), (Boolean)data.next());
        }

        @Override
        public void apply() {
            if (useDoubleAction) {
                GlStateManager.func_179135_a((!this.red ? 1 : 0) != 0, (boolean)this.green, (boolean)this.blue, (boolean)this.alpha);
            }
            GlStateManager.func_179135_a((boolean)this.red, (boolean)this.green, (boolean)this.blue, (boolean)this.alpha);
            if (forceAction) {
                GL11.glColorMask((boolean)this.red, (boolean)this.green, (boolean)this.blue, (boolean)this.alpha);
            }
        }
    }

    protected static class RescaleNormalState
    implements State {
        protected final boolean rescalenormal;

        @Override
        public String getName() {
            return "rescalenormal";
        }

        protected RescaleNormalState(boolean rescalenormal) {
            this.rescalenormal = rescalenormal;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.rescalenormal);
        }

        @Override
        public State create(Iterator<Object> data) {
            return new RescaleNormalState((Boolean)data.next());
        }

        @Override
        public void apply() {
            if (this.rescalenormal) {
                if (useDoubleAction) {
                    GlStateManager.func_179101_C();
                }
                GlStateManager.func_179091_B();
                if (forceAction) {
                    GL11.glEnable((int)32826);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179091_B();
                }
                GlStateManager.func_179101_C();
                if (forceAction) {
                    GL11.glDisable((int)32826);
                }
            }
        }
    }

    protected static class ShadeModelState
    implements State {
        protected final int activeShadeModel;

        @Override
        public String getName() {
            return "shademodel";
        }

        protected ShadeModelState(int activeShadeModel) {
            this.activeShadeModel = activeShadeModel;
        }

        @Override
        public void store(List<Object> data) {
            data.add(new GlConstant(this.activeShadeModel));
        }

        @Override
        public State create(Iterator<Object> data) {
            return new ShadeModelState((Integer)data.next());
        }

        @Override
        public void apply() {
            if (useDoubleAction) {
                GlStateManager.func_179103_j((int)(this.activeShadeModel == 7424 ? 7425 : 7424));
            }
            GlStateManager.func_179103_j((int)this.activeShadeModel);
            if (forceAction) {
                GL11.glShadeModel((int)this.activeShadeModel);
            }
        }
    }

    protected static class NormalizeState
    implements State {
        protected final boolean normalize;

        @Override
        public String getName() {
            return "normalize";
        }

        protected NormalizeState(boolean normalize) {
            this.normalize = normalize;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.normalize);
        }

        @Override
        public State create(Iterator<Object> data) {
            return new NormalizeState((Boolean)data.next());
        }

        @Override
        public void apply() {
            if (this.normalize) {
                if (useDoubleAction) {
                    GlStateManager.func_179133_A();
                }
                GlStateManager.func_179108_z();
                if (forceAction) {
                    GL11.glEnable((int)2977);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179108_z();
                }
                GlStateManager.func_179133_A();
                if (forceAction) {
                    GL11.glDisable((int)2977);
                }
            }
        }
    }

    protected static class ClearState
    implements State {
        protected final double depth;
        protected final float red;
        protected final float green;
        protected final float blue;
        protected final float alpha;

        @Override
        public String getName() {
            return "clear";
        }

        protected ClearState(double depth, float red, float green, float blue, float alpha) {
            this.depth = depth;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.depth);
            data.add(Float.valueOf(this.red));
            data.add(Float.valueOf(this.green));
            data.add(Float.valueOf(this.blue));
            data.add(Float.valueOf(this.alpha));
        }

        @Override
        public State create(Iterator<Object> data) {
            return new ClearState((Double)data.next(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue());
        }

        @Override
        public void apply() {
            if (useDoubleAction) {
                GlStateManager.func_179151_a((double)0.5);
                GlStateManager.func_179151_a((double)0.6);
                GlStateManager.func_179082_a((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179082_a((float)0.6f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            GlStateManager.func_179151_a((double)this.depth);
            GlStateManager.func_179082_a((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
            if (forceAction) {
                GL11.glClearDepth((double)this.depth);
                GL11.glClearColor((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
            }
        }
    }

    protected static class ColorLogicState
    implements State {
        protected final boolean colorLogicOp;
        protected final int opcode;

        @Override
        public String getName() {
            return "colorlogic";
        }

        protected ColorLogicState(boolean colorLogicOp, int opcode) {
            this.colorLogicOp = colorLogicOp;
            this.opcode = opcode;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.colorLogicOp);
            if (this.colorLogicOp) {
                data.add(new GlConstant(this.opcode));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean next = (Boolean)data.next();
            if (next) {
                return new ColorLogicState(next, (Integer)data.next());
            }
            return new ColorLogicState(next, 0);
        }

        @Override
        public void apply() {
            if (this.colorLogicOp) {
                if (useDoubleAction) {
                    GlStateManager.func_179134_v();
                    GlStateManager.func_179116_f((int)5376);
                    GlStateManager.func_179116_f((int)5391);
                }
                GlStateManager.func_179115_u();
                GlStateManager.func_179116_f((int)this.opcode);
                if (forceAction) {
                    GL11.glEnable((int)3058);
                    GL11.glLogicOp((int)this.opcode);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179115_u();
                }
                GlStateManager.func_179134_v();
                if (forceAction) {
                    GL11.glDisable((int)3058);
                }
            }
        }
    }

    protected static class PolygonOffsetState
    implements State {
        protected final boolean polygonOffsetFill;
        protected final float factor;
        protected final float units;

        @Override
        public String getName() {
            return "polygonoffset";
        }

        protected PolygonOffsetState(boolean polygonOffsetFill, float factor, float units) {
            this.polygonOffsetFill = polygonOffsetFill;
            this.factor = factor;
            this.units = units;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.polygonOffsetFill);
            if (this.polygonOffsetFill) {
                data.add(Float.valueOf(this.factor));
                data.add(Float.valueOf(this.units));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean next = (Boolean)data.next();
            if (next) {
                return new PolygonOffsetState(next, ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue());
            }
            return new PolygonOffsetState(next, 0.0f, 0.0f);
        }

        @Override
        public void apply() {
            if (this.polygonOffsetFill) {
                if (useDoubleAction) {
                    GlStateManager.func_179113_r();
                    GlStateManager.func_179136_a((float)0.5f, (float)1.0f);
                    GlStateManager.func_179136_a((float)0.6f, (float)1.0f);
                }
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)this.factor, (float)this.units);
                if (forceAction) {
                    GL11.glEnable((int)32823);
                    GL11.glPolygonOffset((float)this.factor, (float)this.units);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179088_q();
                }
                GlStateManager.func_179113_r();
                if (forceAction) {
                    GL11.glDisable((int)32823);
                }
            }
        }
    }

    protected static class CullState
    implements State {
        protected final boolean cullFace;
        protected final int mode;

        @Override
        public String getName() {
            return "cullface";
        }

        protected CullState(boolean cullFace, int mode) {
            this.cullFace = cullFace;
            this.mode = mode;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.cullFace);
            if (this.cullFace) {
                data.add(new GlConstant(this.mode));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            Boolean next = (Boolean)data.next();
            if (next.booleanValue()) {
                return new CullState(next, (Integer)data.next());
            }
            return new CullState(next, 0);
        }

        @Override
        public void apply() {
            if (this.cullFace) {
                if (useDoubleAction) {
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179107_e((int)1028);
                    GlStateManager.func_179107_e((int)1029);
                }
                GlStateManager.func_179089_o();
                GlStateManager.func_179107_e((int)this.mode);
                if (forceAction) {
                    GL11.glEnable((int)2884);
                    GL11.glCullFace((int)this.mode);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179127_m();
                }
                GlStateManager.func_179106_n();
                if (forceAction) {
                    GL11.glDisable((int)2884);
                }
            }
        }
    }

    protected static class FogState
    implements State {
        protected final boolean fog;
        protected final int mode;
        protected final float density;
        protected final float start;
        protected final float end;

        @Override
        public String getName() {
            return "fog";
        }

        protected FogState(boolean fog, int mode, float density, float start, float end) {
            this.fog = fog;
            this.mode = mode;
            this.density = density;
            this.start = start;
            this.end = end;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.fog);
            if (this.fog) {
                data.add(new GlConstant(this.mode));
                data.add(Float.valueOf(this.density));
                data.add(Float.valueOf(this.start));
                data.add(Float.valueOf(this.end));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            Boolean next = (Boolean)data.next();
            if (next.booleanValue()) {
                return new FogState(next, (Integer)data.next(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue(), ((Float)data.next()).floatValue());
            }
            return new FogState(next, 0, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void apply() {
            if (this.fog) {
                if (useDoubleAction) {
                    GlStateManager.func_179106_n();
                    GlStateManager.func_179093_d((int)9729);
                    GlStateManager.func_179095_a((float)0.5f);
                    GlStateManager.func_179102_b((float)0.5f);
                    GlStateManager.func_179153_c((float)0.5f);
                    GlStateManager.func_179093_d((int)2048);
                    GlStateManager.func_179095_a((float)0.6f);
                    GlStateManager.func_179102_b((float)0.6f);
                    GlStateManager.func_179153_c((float)0.6f);
                }
                GlStateManager.func_179127_m();
                GlStateManager.func_179093_d((int)this.mode);
                GlStateManager.func_179095_a((float)this.density);
                GlStateManager.func_179102_b((float)this.start);
                GlStateManager.func_179153_c((float)this.end);
                if (forceAction) {
                    GL11.glEnable((int)2912);
                    GL11.glFogi((int)2917, (int)this.mode);
                    GL11.glFogf((int)2914, (float)this.density);
                    GL11.glFogf((int)2915, (float)this.start);
                    GL11.glFogf((int)2916, (float)this.end);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179127_m();
                }
                GlStateManager.func_179106_n();
                if (forceAction) {
                    GL11.glDisable((int)2912);
                }
            }
        }
    }

    protected static class DepthState
    implements State {
        protected final boolean depthTest;
        protected final boolean maskEnabled;
        protected final int depthFunc;

        @Override
        public String getName() {
            return "depth";
        }

        protected DepthState(boolean depthTest, boolean maskEnabled, int depthFunc) {
            this.depthTest = depthTest;
            this.maskEnabled = maskEnabled;
            this.depthFunc = depthFunc;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.depthTest);
            if (this.depthTest) {
                data.add(this.maskEnabled);
                if (this.maskEnabled) {
                    data.add(new GlConstant(this.depthFunc));
                }
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            Boolean next0 = (Boolean)data.next();
            if (next0.booleanValue()) {
                Boolean next1 = (Boolean)data.next();
                if (next1.booleanValue()) {
                    return new DepthState(next0, next1, (Integer)data.next());
                }
                return new DepthState(next0, next1, 0);
            }
            return new DepthState(next0, false, 0);
        }

        @Override
        public void apply() {
            if (this.depthTest) {
                if (useDoubleAction) {
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179132_a((!this.maskEnabled ? 1 : 0) != 0);
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)this.maskEnabled);
                if (this.maskEnabled) {
                    if (useDoubleAction) {
                        GlStateManager.func_179143_c((int)512);
                    }
                    GlStateManager.func_179143_c((int)this.depthFunc);
                }
                if (forceAction) {
                    GL11.glEnable((int)2929);
                    GL11.glDepthMask((boolean)this.maskEnabled);
                    GL11.glDepthFunc((int)this.depthFunc);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179126_j();
                }
                GlStateManager.func_179097_i();
                if (forceAction) {
                    GL11.glDisable((int)2929);
                }
            }
        }
    }

    protected static class BlendState
    implements State {
        protected final boolean blend;
        protected final int srcFactor;
        protected final int dstFactor;

        @Override
        public String getName() {
            return "blend";
        }

        protected BlendState(boolean blend, int srcFactor, int dstFactor) {
            this.blend = blend;
            this.srcFactor = srcFactor;
            this.dstFactor = dstFactor;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.blend);
            if (this.blend) {
                data.add(new GlConstant(this.srcFactor));
                data.add(new GlConstant(this.dstFactor));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean next = (Boolean)data.next();
            if (next) {
                return new BlendState(next, (Integer)data.next(), (Integer)data.next());
            }
            return new BlendState(next, 0, 0);
        }

        @Override
        public void apply() {
            if (this.blend) {
                if (useDoubleAction) {
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179112_b((int)0, (int)0);
                    GlStateManager.func_179112_b((int)1, (int)1);
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)this.srcFactor, (int)this.dstFactor);
                if (forceAction) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)this.srcFactor, (int)this.dstFactor);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179147_l();
                }
                GlStateManager.func_179084_k();
                if (forceAction) {
                    GL11.glDisable((int)3042);
                }
            }
        }
    }

    protected static class ColorMaterialState
    implements State {
        protected final boolean colorMaterial;
        protected final int face;
        protected final int mode;

        @Override
        public String getName() {
            return "alpha";
        }

        protected ColorMaterialState(boolean colorMaterial, int face, int mode) {
            this.colorMaterial = colorMaterial;
            this.face = face;
            this.mode = mode;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.colorMaterial);
            if (this.colorMaterial) {
                data.add(new GlConstant(this.face));
                data.add(new GlConstant(this.mode));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean next = (Boolean)data.next();
            if (next) {
                return new ColorMaterialState(next, (Integer)data.next(), (Integer)data.next());
            }
            return new ColorMaterialState(next, 0, 0);
        }

        @Override
        public void apply() {
            if (this.colorMaterial) {
                if (useDoubleAction) {
                    GlStateManager.func_179119_h();
                    GlStateManager.func_179104_a((int)1028, (int)5632);
                    GlStateManager.func_179104_a((int)1029, (int)5632);
                }
                GlStateManager.func_179142_g();
                GlStateManager.func_179104_a((int)this.face, (int)this.mode);
                if (forceAction) {
                    GL11.glEnable((int)2903);
                    GL11.glColorMaterial((int)this.face, (int)this.mode);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179142_g();
                }
                GlStateManager.func_179119_h();
                if (forceAction) {
                    GL11.glDisable((int)2903);
                }
            }
        }
    }

    protected static class LightState
    implements State {
        protected final boolean[] light;

        @Override
        public String getName() {
            return "light";
        }

        protected LightState(boolean[] light) {
            this.light = light;
        }

        @Override
        public void store(List<Object> data) {
            for (int i = 0; i < this.light.length; ++i) {
                data.add(this.light[i]);
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean[] b = new boolean[8];
            for (int i = 0; i < this.light.length; ++i) {
                b[i] = (Boolean)data.next();
            }
            return new LightState(b);
        }

        @Override
        public void apply() {
            for (int i = 0; i < this.light.length; ++i) {
                if (this.light[i]) {
                    if (useDoubleAction) {
                        GlStateManager.func_179122_b((int)i);
                    }
                    GlStateManager.func_179085_a((int)i);
                    if (!forceAction) continue;
                    GL11.glEnable((int)(16384 + i));
                    continue;
                }
                if (useDoubleAction) {
                    GlStateManager.func_179085_a((int)i);
                }
                GlStateManager.func_179122_b((int)i);
                if (!forceAction) continue;
                GL11.glDisable((int)(16384 + i));
            }
        }
    }

    protected static class LightingState
    implements State {
        protected final boolean lighting;

        @Override
        public String getName() {
            return "lighting";
        }

        protected LightingState(boolean lighting) {
            this.lighting = lighting;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.lighting);
        }

        @Override
        public State create(Iterator<Object> data) {
            return new LightingState((Boolean)data.next());
        }

        @Override
        public void apply() {
            if (this.lighting) {
                if (useDoubleAction) {
                    GlStateManager.func_179140_f();
                }
                GlStateManager.func_179145_e();
                if (forceAction) {
                    GL11.glEnable((int)2896);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179145_e();
                }
                GlStateManager.func_179140_f();
                if (forceAction) {
                    GL11.glDisable((int)2896);
                }
            }
        }
    }

    protected static class AlphaState
    implements State {
        protected final boolean alphaTest;
        protected final int func;
        protected final float ref;

        @Override
        public String getName() {
            return "alpha";
        }

        AlphaState(boolean alphaTest, int func, float ref) {
            this.alphaTest = alphaTest;
            this.func = func;
            this.ref = ref;
        }

        @Override
        public void store(List<Object> data) {
            data.add(this.alphaTest);
            if (this.alphaTest) {
                data.add(new GlConstant(this.func));
                data.add(Float.valueOf(this.ref));
            }
        }

        @Override
        public State create(Iterator<Object> data) {
            boolean next = (Boolean)data.next();
            if (next) {
                return new AlphaState(next, (Integer)data.next(), ((Float)data.next()).floatValue());
            }
            return new AlphaState(next, 0, 0.0f);
        }

        @Override
        public void apply() {
            if (this.alphaTest) {
                if (useDoubleAction) {
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179092_a((int)512, (float)0.0f);
                    GlStateManager.func_179092_a((int)519, (float)0.0f);
                }
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)this.func, (float)this.ref);
                if (forceAction) {
                    GL11.glEnable((int)3008);
                    GL11.glAlphaFunc((int)this.func, (float)this.ref);
                }
            } else {
                if (useDoubleAction) {
                    GlStateManager.func_179141_d();
                }
                GlStateManager.func_179118_c();
                if (forceAction) {
                    GL11.glDisable((int)3008);
                }
            }
        }
    }

    protected static class GlConstant {
        protected final int constant;

        protected GlConstant(int constant) {
            this.constant = constant;
        }

        public String toString() {
            for (Field field : GL11.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    int val = field.getInt(null);
                    if (val != this.constant) continue;
                    return "GL11." + field.getName();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return "" + this.constant;
        }
    }

    private static interface State {
        public String getName();

        public State create(Iterator<Object> var1);

        public void store(List<Object> var1);

        public void apply();
    }
}

