/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cofh.api.energy.ItemEnergyContainer;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTravelStaff
extends ItemEnergyContainer
implements IItemOfTravel,
IResourceTooltipProvider {
    private long lastBlickTick = 0L;

    public static boolean isEquipped(EntityPlayer ep) {
        if (ep == null || ep.func_71045_bC() == null) {
            return false;
        }
        return ep.func_71045_bC().func_77973_b() == EnderIO.itemTravelStaff;
    }

    public static ItemTravelStaff create() {
        ItemTravelStaff result = new ItemTravelStaff();
        result.init();
        return result;
    }

    protected ItemTravelStaff() {
        super(Config.darkSteelPowerStorageLevelTwo, Config.darkSteelPowerStorageLevelTwo / 100, 0);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemTravelStaff.name());
        this.func_77656_e(16);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemTravelStaff.getUnlocalisedName());
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    public ItemStack func_77659_a(ItemStack equipped, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(equipped, player)) {
                player.func_71038_i();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return equipped;
        }
        if (world.field_72995_K) {
            TravelController.instance.activateTravelAccessable(equipped, world, player, TravelSource.STAFF);
        }
        player.func_71038_i();
        return equipped;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int res = super.receiveEnergy(container, maxReceive, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int res = super.extractEnergy(container, maxExtract, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    @Override
    public void extractInternal(ItemStack item, int powerUse) {
        int res = Math.max(0, this.getEnergyStored(item) - powerUse);
        this.setEnergy(item, res);
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a("Energy", energy);
        this.updateDamage(container);
    }

    public void setFull(ItemStack container) {
        this.setEnergy(container, Config.darkSteelPowerStorageLevelTwo);
    }

    private void updateDamage(ItemStack stack) {
        float r = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        int res = 16 - (int)(r * 16.0f);
        stack.func_77964_b(res);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return ItemTravelStaff.isEquipped(ep);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

