/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.tool;

import cofh.api.CoFHAPIProps;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.API;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;

public class EnderIOCrashCallable
implements ICrashCallable {
    public static void create() {
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new EnderIOCrashCallable());
    }

    private List<String> collectData() {
        ArrayList<String> result = new ArrayList<String>();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine()) {
            result.add(" * Optifine is installed. This is NOT supported.");
        }
        for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
            if ("appliedenergistics2|API".equals(modContainer.getModId())) {
                if ("rv1".equals(modContainer.getVersion())) {
                    result.add(" * An unsupportted old AE2 API is installed (" + modContainer.getVersion() + " from " + modContainer.getSource().getName() + ").");
                    result.add("   Ender IO was build against API version rv2 and will NOT work with older versions.");
                    continue;
                }
                if ("rv2".equals(modContainer.getVersion())) continue;
                result.add(" * An unknown AE2 API is installed (" + modContainer.getVersion() + " from " + modContainer.getSource().getName() + ").");
                result.add("   Ender IO was build against API version rv2 and may or may not work with a newer version.");
                continue;
            }
            if ("CoFHAPI|energy".equals(modContainer.getModId())) {
                if ("1.7.10R1.0.0".equals(modContainer.getVersion()) || "1.7.10R1.0.1".equals(modContainer.getVersion())) {
                    result.add(" * An unsupportted old RF API is installed (" + modContainer.getVersion() + " from " + modContainer.getSource().getName() + ").");
                    result.add("   Ender IO needs at least 1.8.9R1.2.0B1 and will NOT work with older versions.");
                    continue;
                }
                Package caep = Package.getPackage("cofh.api.energy");
                if (caep != null) {
                    API api = caep.getAnnotation(API.class);
                    if (api != null) {
                        String apiVersion = api.apiVersion();
                        if (apiVersion != null) {
                            if (apiVersion.equals(modContainer.getVersion())) continue;
                            if ("1.7.10R1.0.0".equals(apiVersion) || "1.7.10R1.0.1".equals(apiVersion)) {
                                result.add(" * An unsupportted old RF API is installed (" + apiVersion + " from (guessing) " + EnderIOCrashCallable.whereFrom(CoFHAPIProps.class) + ").");
                                result.add("   Ender IO needs at least 1.8.9R1.2.0B1 and will NOT work with older versions.");
                                continue;
                            }
                            result.add(" * The RF API that is being used (" + apiVersion + " from (guessing) " + EnderIOCrashCallable.whereFrom(CoFHAPIProps.class) + ") differes from that that is reported as being loaded (" + modContainer.getVersion() + " from " + modContainer.getSource().getName() + ").");
                            result.add("   It is a supported version, but that difference may lead to problems.");
                            continue;
                        }
                        result.add(" * The RF API that is being used has no version number. This may lead to problems.");
                        continue;
                    }
                    result.add(" * The RF API that is being used has no API annotation. This may lead to problems.");
                    continue;
                }
                result.add(" * No RF API could be found in memory. This may be may due to an early crash.");
                continue;
            }
            if (modContainer.getModId() == null || !modContainer.getModId().startsWith("EnderIOAPI")) continue;
            if (!"0.0.2".equals(modContainer.getVersion())) {
                result.add(" * Another mod is shipping a version of our API that doesn't match our version (" + modContainer.getVersion() + " from " + modContainer.getSource().getName() + "). That may not actually work.");
                continue;
            }
            if (modContainer.getSource().getName() == null || modContainer.getSource().getName().startsWith("EnderIO") || modContainer.getSource().getName().startsWith("enderio") || modContainer.getSource().getName().equals("bin")) continue;
            result.add(" * Our API got loaded from " + modContainer.getSource().getName() + ". That's unexpected.");
        }
        String badBrand = null;
        for (String brand : FMLCommonHandler.instance().getModName().split(",")) {
            if (brand == null || brand.equals("fml") || brand.equals("forge")) continue;
            badBrand = badBrand == null ? brand : badBrand + ", " + brand;
        }
        if (badBrand != null) {
            result.add("An unsupported base software is installed: '" + badBrand + "'. This is NOT supported.");
        }
        return result;
    }

    public String call() throws Exception {
        List<String> data = this.collectData();
        if (data.isEmpty()) {
            return "No known problems detected.";
        }
        String msg = "Found the following problem(s) with your installation (That does NOT mean that Ender IO caused the crash or was involved in it in any way. We add this information to help finding common problems, not as an invitation to post any crash you encounter to Ender IO's issue tracker.):\n";
        for (String string : data) {
            msg = msg + "                 " + string + "\n";
        }
        msg = msg + "                 This may (look up the meaning of 'may' in the dictionary if you're not sure what it means) have caused the error. Try reproducing the crash WITHOUT this/these mod(s) before reporting it.";
        return msg;
    }

    public String getLabel() {
        return "EnderIO";
    }

    public static String whereFrom(Class<?> c) {
        if (c == null) {
            return null;
        }
        try {
            String name;
            URL resource;
            ClassLoader loader = c.getClassLoader();
            if (loader == null) {
                for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
                }
            }
            if (loader != null && (resource = loader.getResource((name = c.getCanonicalName()).replace(".", "/") + ".class")) != null) {
                return resource.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<unknown>";
    }
}

