/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import net.minecraft.entity.player.EntityPlayer;

public class XpUtil {
    public static final int XP_PER_BOTTLE = 8;
    public static final int RATIO = 20;
    public static final int LIQUID_PER_XP_BOTTLE = 160;

    public static int liquidToExperience(int liquid) {
        return liquid / 20;
    }

    public static int experienceToLiquid(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return XpUtil.experienceToLiquid(XpUtil.getExperienceForLevel(level));
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        if (level == 0) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < level; ++i) {
            res += XpUtil.getXpBarCapacity(i);
        }
        return res;
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (XpUtil.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)XpUtil.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, XpUtil.getPlayerXP(player) + amount);
        player.field_71068_ca = XpUtil.getLevelForExperience(experience);
        int expForLevel = XpUtil.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }
}

