/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.CommonProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.render.ConduitBundleRenderManager;
import crazypants.enderio.config.Config;
import crazypants.enderio.enderface.EnderIoRenderer;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.fluid.Buckets;
import crazypants.enderio.gui.TooltipHandlerBurnTime;
import crazypants.enderio.gui.TooltipHandlerFluid;
import crazypants.enderio.gui.TooltipHandlerGrinding;
import crazypants.enderio.item.ConduitProbeOverlayRenderer;
import crazypants.enderio.item.KeyTracker;
import crazypants.enderio.item.ToolTickHandler;
import crazypants.enderio.item.YetaWrenchOverlayRenderer;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.UpgradeRenderDispatcher;
import crazypants.enderio.item.skull.EndermanSkullRenderer;
import crazypants.enderio.item.skull.TileEndermanSkull;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.render.CapBankRenderer;
import crazypants.enderio.machine.enchanter.EnchanterModelRenderer;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import crazypants.enderio.machine.farm.FarmingStationSpecialRenderer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.gauge.TESRGauge;
import crazypants.enderio.machine.gauge.TileGauge;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machine.generator.zombie.ZombieGeneratorRenderer;
import crazypants.enderio.machine.killera.KillerJoeRenderer;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.machine.monitor.TESRPowerMonitor;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.machine.obelisk.render.ObeliskRenderManager;
import crazypants.enderio.machine.ranged.MarkerParticle;
import crazypants.enderio.machine.reservoir.ReservoirRenderer;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.enderio.machine.soul.SoulBinderTESR;
import crazypants.enderio.machine.soul.TileSoulBinder;
import crazypants.enderio.machine.tank.TankFluidRenderer;
import crazypants.enderio.machine.tank.TileTank;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.render.TransceiverRenderer;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.ItemModelRegistry;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.anchor.TravelEntitySpecialRenderer;
import crazypants.util.ClientUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static int[][] sideAndFacingToSpriteOffset = new int[][]{{3, 2, 0, 0, 0, 0}, {2, 3, 1, 1, 1, 1}, {1, 1, 3, 2, 5, 4}, {0, 0, 2, 3, 4, 5}, {4, 5, 4, 5, 3, 2}, {5, 4, 5, 4, 2, 3}};
    private boolean checkedNei = false;
    private boolean neiInstalled = false;

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public boolean isAnEiInstalled() {
        if (this.checkedNei) {
            return this.neiInstalled;
        }
        try {
            Class.forName("crazypants.enderio.nei.EnchanterRecipeHandler");
            this.neiInstalled = true;
        }
        catch (Exception e) {
            this.neiInstalled = false;
        }
        if (!this.neiInstalled) {
            try {
                Class.forName("crazypants.enderio.jei.AlloyRecipeCategory");
                this.neiInstalled = true;
            }
            catch (Exception e) {
                this.neiInstalled = false;
            }
        }
        this.checkedNei = true;
        return this.neiInstalled;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void loadIcons() {
        SmartModelAttacher.create();
        PaintRegistry.create();
    }

    @Override
    public void preInit() {
        super.preInit();
        SpecialTooltipHandler tt = SpecialTooltipHandler.INSTANCE;
        tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerGrinding());
        tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerBurnTime());
        if (Config.addFuelTooltipsToAllFluidContainers) {
            tt.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerFluid());
        }
        ConduitBundleRenderManager.instance.registerRenderers();
        EnderIO.fluids.registerRenderers();
        SmartModelAttacher.registerBlockItemModels();
        if (EnderIO.blockDarkIronBars != null) {
            ClientUtil.registerRenderer(Item.func_150898_a((Block)EnderIO.blockDarkIronBars), ModObject.blockDarkIronBars.getUnlocalisedName());
        }
        this.registerRenderers(EnderIO.blockDarkSteelAnvil);
        if (EnderIO.blockDarkSteelLadder != null) {
            ClientUtil.registerRenderer(Item.func_150898_a((Block)EnderIO.blockDarkSteelLadder), ModObject.blockDarkSteelLadder.getUnlocalisedName());
        }
        this.registerRenderers(EnderIO.blockIngotStorage);
        this.registerRenderers(EnderIO.blockEndermanSkull);
        this.registerRenderers(EnderIO.blockElectricLight);
        ClientUtil.registerDefaultItemRenderer(EnderIO.blockTravelPlatform);
        ClientUtil.registerDefaultItemRenderer(EnderIO.blockWirelessCharger);
        ClientUtil.registerDefaultItemRenderer(EnderIO.blockVacuumChest);
        ClientUtil.registerDefaultItemRenderer(EnderIO.blockReinforcedObsidian);
        ObeliskRenderManager.INSTANCE.registerRenderers();
        if (EnderIO.blockEnchanter != null) {
            EnchanterModelRenderer emr = new EnchanterModelRenderer();
            ClientRegistry.bindTileEntitySpecialRenderer(TileEnchanter.class, (TileEntitySpecialRenderer)emr);
            ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)EnderIO.blockEnchanter), (int)0, TileEnchanter.class);
            ClientUtil.registerRenderer(Item.func_150898_a((Block)EnderIO.blockEnchanter), ModObject.blockEnchanter.getUnlocalisedName());
        }
        if (EnderIO.blockFarmStation != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileFarmStation.class, (TileEntitySpecialRenderer)new FarmingStationSpecialRenderer());
        }
        if (EnderIO.blockZombieGenerator != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileZombieGenerator.class, (TileEntitySpecialRenderer)new ZombieGeneratorRenderer());
        }
        if (EnderIO.blockKillerJoe != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileKillerJoe.class, (TileEntitySpecialRenderer)new KillerJoeRenderer());
        }
        if (EnderIO.blockCapBank != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileCapBank.class, (TileEntitySpecialRenderer)new CapBankRenderer());
        }
        if (EnderIO.blockEnderIo != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEnderIO.class, (TileEntitySpecialRenderer)new EnderIoRenderer());
            ClientUtil.registerRenderer(Item.func_150898_a((Block)EnderIO.blockEnderIo), ModObject.blockEnderIo.getUnlocalisedName());
        }
        if (EnderIO.blockReservoir != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileReservoir.class, (TileEntitySpecialRenderer)new ReservoirRenderer(EnderIO.blockReservoir));
        }
        if (EnderIO.blockTank != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new TankFluidRenderer());
        }
        if (EnderIO.blockEndermanSkull != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEndermanSkull.class, (TileEntitySpecialRenderer)new EndermanSkullRenderer());
        }
        if (Config.transceiverEnabled) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileTransceiver.class, (TileEntitySpecialRenderer)new TransceiverRenderer());
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileTravelAnchor.class, (TileEntitySpecialRenderer)new TravelEntitySpecialRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePowerMonitor.class, (TileEntitySpecialRenderer)new TESRPowerMonitor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGauge.class, (TileEntitySpecialRenderer)new TESRGauge());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSoulBinder.class, (TileEntitySpecialRenderer)new SoulBinderTESR());
        new YetaWrenchOverlayRenderer();
        new ConduitProbeOverlayRenderer();
        ClientUtil.registerRenderer(EnderIO.itemYetaWench, ModObject.itemYetaWrench.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemEnderface, ModObject.itemEnderface.getUnlocalisedName());
        EnderIO.itemAlloy.registerRenderers();
        EnderIO.itemBasicCapacitor.registerRenderers();
        EnderIO.itemPowderIngot.registerRenderers();
        if (EnderIO.itemFrankenSkull != null) {
            EnderIO.itemFrankenSkull.registerRenderers();
        }
        this.registerRenderers(EnderIO.itemMachinePart);
        this.registerRenderers(EnderIO.itemMaterial);
        this.registerRenderers(EnderIO.itemEnderFood);
        this.registerRenderers(EnderIO.itemBasicFilterUpgrade);
        this.registerRenderers(EnderIO.itemExtractSpeedUpgrade);
        this.registerRenderers(EnderIO.itemFunctionUpgrade);
        this.registerRenderers(EnderIO.itemFunctionUpgrade);
        this.registerRenderers(EnderIO.itemSoulVessel);
        this.registerRenderers(EnderIO.itemPowerConduit);
        this.registerRenderers(EnderIO.itemLiquidConduit);
        this.registerRenderers(EnderIO.itemItemConduit);
        this.registerRenderers(EnderIO.itemRedstoneConduit);
        ClientUtil.registerRenderer(EnderIO.itemTravelStaff, ModObject.itemTravelStaff.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemXpTransfer, ModObject.itemXpTransfer.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemBrokenSpawner, ModObject.itemBrokenSpawner.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemExistingItemFilter, ModObject.itemExistingItemFilter.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemModItemFilter, ModObject.itemModItemFilter.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemPowerItemFilter, ModObject.itemPowerItemFilter.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemConduitProbe, ModObject.itemConduitProbe.getUnlocalisedName());
        ClientUtil.registerRenderer(EnderIO.itemCoordSelector, ModObject.itemCoordSelector.getUnlocalisedName());
        DarkSteelItems.registerItemRenderers();
        Buckets.registerRenderers();
        ItemModelRegistry.create();
        ItemModelRegistry.registerRotating("enderCrystal", 2);
        if (Config.useSneakMouseWheelYetaWrench) {
            ToolTickHandler th = new ToolTickHandler();
            MinecraftForge.EVENT_BUS.register((Object)th);
        }
        MinecraftForge.EVENT_BUS.register((Object)TravelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)KeyTracker.instance);
        MinecraftForge.EVENT_BUS.register((Object)SoundDetector.instance);
        MinecraftForge.EVENT_BUS.register((Object)UpgradeRenderDispatcher.instance);
    }

    @Override
    public void init() {
        super.init();
        SmartModelAttacher.registerColoredBlocksAndItems();
    }

    private void registerRenderers(IHaveRenderers bob) {
        if (bob != null) {
            bob.registerRenderers();
        }
    }

    @Override
    public double getReachDistanceForPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        return super.getReachDistanceForPlayer(entityPlayer);
    }

    @Override
    public void setInstantConfusionOnPlayer(EntityPlayer ent, int duration) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, true, true));
        Minecraft.func_71410_x().field_71439_g.field_71086_bY = 1.0f;
    }

    @Override
    public long getTickCount() {
        return this.clientTickCount;
    }

    @Override
    protected void onClientTick() {
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null) {
            ++this.clientTickCount;
            YetaUtil.onTick();
        }
    }

    @Override
    public void markBlock(World worldObj, BlockPos pos, Vector4f color) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new MarkerParticle(worldObj, pos, color));
    }
}

