/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.capacitor.LootSelector;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.material.Alloy;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootManager {
    private static LootManager INSTANCE = new LootManager();
    private LootCondition[] noConditions = new LootCondition[0];

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    private LootManager() {
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent evt) {
        LootTable table = evt.getTable();
        if (evt.getName().equals((Object)LootTableList.field_186422_d)) {
            ArrayList<LootEntryItem> entries = new ArrayList<LootEntryItem>();
            if (Config.lootDarkSteel) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.DARK_STEEL.ordinal(), 1.0f, 3.0f, 15));
            }
            if (Config.lootItemConduitProbe) {
                entries.add(this.createLootEntry(EnderIO.itemConduitProbe, 1.0f, 1.0f, 10));
            }
            if (Config.lootQuartz) {
                entries.add(this.createLootEntry(Items.field_151128_bU, 3.0f, 16.0f, 20));
            }
            if (Config.lootNetherWart) {
                entries.add(this.createLootEntry(Items.field_151075_bm, 1.0f, 4.0f, 10));
            }
            if (Config.lootEnderPearl) {
                entries.add(this.createLootEntry(Items.field_151079_bi, 1.0f, 2.0f, 30));
            }
            if (Config.lootTheEnder) {
                entries.add(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1.0f, 1.0f, 5));
            }
            if (Config.lootDarkSteelBoots) {
                entries.add(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 1.0f, 1.0f, 5));
            }
            entries.add(this.createLootCapacitor(15));
            if (entries.isEmpty()) {
                return;
            }
            int minRolls = Math.min(2, Math.max(0, entries.size() - 2));
            int maxRolls = Math.min(entries.size(), entries.size() - 2);
            LootPool lp = this.createPool(minRolls, maxRolls);
            for (LootEntry lootEntry : entries) {
                lp.addEntry(lootEntry);
            }
            table.addPool(lp);
        } else if (evt.getName().equals((Object)LootTableList.field_186423_e)) {
            ArrayList<LootEntryItem> entries = new ArrayList<LootEntryItem>();
            if (Config.lootElectricSteel) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.ELECTRICAL_STEEL.ordinal(), 2.0f, 6.0f, 20));
            }
            if (Config.lootRedstoneAlloy) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.REDSTONE_ALLOY.ordinal(), 3.0f, 6.0f, 35));
            }
            if (Config.lootDarkSteel) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.DARK_STEEL.ordinal(), 3.0f, 6.0f, 35));
            }
            if (Config.lootPhasedIron) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.PULSATING_IRON.ordinal(), 1.0f, 2.0f, 10));
            }
            if (Config.lootPhasedGold) {
                entries.add(this.createLootEntry(EnderIO.itemAlloy, Alloy.VIBRANT_ALLOY.ordinal(), 1.0f, 2.0f, 5));
            }
            if (Config.lootTheEnder) {
                entries.add(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1.0f, 1.0f, 5));
            }
            if (Config.lootDarkSteelBoots) {
                entries.add(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 1.0f, 1.0f, 5));
            }
            entries.add(this.createLootCapacitor(5));
            if (entries.isEmpty()) {
                return;
            }
            int minRolls = Math.min(2, Math.max(0, entries.size() - 2));
            int maxRolls = Math.min(entries.size(), entries.size() - 2);
            LootPool lp = this.createPool(minRolls, maxRolls);
            for (LootEntry lootEntry : entries) {
                lp.addEntry(lootEntry);
            }
            table.addPool(lp);
        } else if (evt.getName().equals((Object)LootTableList.field_186429_k)) {
            LootPool mainPool = table.getPool("main");
            if (mainPool == null) {
                Log.error("LootManager.onLootTableLoad Could not add to the main loot pool of CHESTS_DESERT_PYRAMID");
                return;
            }
            if (Config.lootTheEnder) {
                mainPool.addEntry((LootEntry)this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1.0f, 1.0f, 15));
            }
            if (Config.lootTravelStaff) {
                mainPool.addEntry((LootEntry)this.createLootEntry(EnderIO.itemTravelStaff, 1.0f, 1.0f, 1));
            }
            mainPool.addEntry((LootEntry)this.createLootCapacitor(25));
        } else if (evt.getName().equals((Object)LootTableList.field_186430_l)) {
            LootPool mainPool = table.getPool("main");
            if (mainPool == null) {
                Log.error("LootManager.onLootTableLoad Could not add to the main loot pool of CHESTS_JUNGLE_TEMPLE");
                return;
            }
            if (Config.lootTheEnder) {
                mainPool.addEntry((LootEntry)this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1.0f, 1.0f, 15));
            }
            if (Config.lootTravelStaff) {
                mainPool.addEntry((LootEntry)this.createLootEntry(EnderIO.itemTravelStaff, 1.0f, 1.0f, 1));
            }
            mainPool.addEntry((LootEntry)this.createLootCapacitor(15));
        }
    }

    private LootPool createPool(int minRolls, int maxRolls) {
        RandomValueRange bonusRollsIn = new RandomValueRange(0.0f, 0.0f);
        RandomValueRange rollsIn = new RandomValueRange((float)minRolls, (float)maxRolls);
        return new LootPool(new LootEntry[0], this.noConditions, rollsIn, bonusRollsIn, "Ender IO");
    }

    private LootEntryItem createLootEntry(Item item, float minStackSize, float maxStackSize, int weight) {
        LootFunction[] functionsIn = new LootFunction[]{new SetCount(this.noConditions, new RandomValueRange(minStackSize, maxStackSize))};
        return new LootEntryItem(item, weight, 1, functionsIn, this.noConditions, item.func_77658_a());
    }

    private LootEntryItem createLootEntry(Item item, int meta, float minStackSize, float maxStackSize, int weight) {
        LootFunction[] functionsIn = new LootFunction[]{new SetCount(this.noConditions, new RandomValueRange(minStackSize, maxStackSize)), new SetMetadata(this.noConditions, new RandomValueRange((float)meta, (float)meta))};
        return new LootEntryItem(item, weight, 1, functionsIn, this.noConditions, item.func_77658_a() + ":" + meta);
    }

    private LootEntryItem createLootCapacitor(int weight) {
        LootFunction[] functionsIn = new LootFunction[]{new SetCount(this.noConditions, new RandomValueRange(1.0f, 1.0f)), new LootSelector(this.noConditions)};
        return new LootEntryItem((Item)EnderIO.itemBasicCapacitor, weight, 1, functionsIn, this.noConditions, EnderIO.itemBasicCapacitor.func_77658_a());
    }
}

