/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.capacitor.CapacitorKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootSelector
extends LootFunction {
    public LootSelector(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        HashMap<Upgrade, Float> keys = new HashMap<Upgrade, Float>();
        float baselevel = this.getRandomBaseLevel(rand);
        int no = this.getRandomCount(rand);
        for (int i = 0; i < no; ++i) {
            Upgrade randomKey = this.getUpgrade(rand);
            float randomLevel = LootSelector.getRandomLevel(baselevel, rand);
            baselevel -= Math.max(randomLevel / 10.0f * rand.nextFloat(), 0.5f);
            if (keys.containsKey((Object)randomKey)) {
                randomLevel = Math.max(randomLevel, ((Float)keys.get((Object)randomKey)).floatValue());
            }
            keys.put(randomKey, Float.valueOf(randomLevel));
        }
        String name = this.buildBaseName(EnderIO.lang.localize("itemBasicCapacitor.name"), baselevel);
        stack = CapacitorHelper.addCapData(stack, CapacitorHelper.SetType.LEVEL, null, baselevel);
        for (Map.Entry entry : keys.entrySet()) {
            stack = CapacitorHelper.addCapData(stack, ((Upgrade)((Object)entry.getKey())).setType, ((Upgrade)((Object)entry.getKey())).capacitorKey, ((Float)entry.getValue()).floatValue());
            name = this.buildName(EnderIO.lang.localize(((Upgrade)((Object)entry.getKey())).langKey, new Object[]{name}), ((Float)entry.getValue()).floatValue());
        }
        stack.func_151001_c(name);
        return stack;
    }

    private int getRandomCount(Random rand) {
        int no = 0;
        switch (rand.nextInt(40)) {
            case 0: {
                ++no;
            }
            case 1: 
            case 2: 
            case 3: {
                ++no;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ++no;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                ++no;
            }
        }
        return ++no;
    }

    private String buildBaseName(String name, float level) {
        name = level < 1.0f ? EnderIO.lang.localize("loot.capacitor.baselevel.10", new Object[]{name}) : (level < 1.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.15", new Object[]{name}) : (level < 2.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.25", new Object[]{name}) : (level < 3.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.35", new Object[]{name}) : EnderIO.lang.localize("loot.capacitor.baselevel.45", new Object[]{name}))));
        return name;
    }

    private String buildName(String name, float level) {
        name = level < 1.0f ? EnderIO.lang.localize("loot.capacitor.level.10", new Object[]{name}) : (level < 1.5f ? EnderIO.lang.localize("loot.capacitor.level.15", new Object[]{name}) : (level < 2.5f ? EnderIO.lang.localize("loot.capacitor.level.25", new Object[]{name}) : (level < 3.0f ? EnderIO.lang.localize("loot.capacitor.level.30", new Object[]{name}) : (level < 3.5f ? EnderIO.lang.localize("loot.capacitor.level.35", new Object[]{name}) : (level < 4.0f ? EnderIO.lang.localize("loot.capacitor.level.40", new Object[]{name}) : (level < 4.25f ? EnderIO.lang.localize("loot.capacitor.level.42", new Object[]{name}) : EnderIO.lang.localize("loot.capacitor.level.45", new Object[]{name})))))));
        return name;
    }

    private float getRandomBaseLevel(Random rand) {
        if (rand.nextFloat() < 0.6f) {
            return 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.5f;
        }
        return 1.0f + rand.nextFloat() + rand.nextFloat() + rand.nextFloat() + rand.nextFloat();
    }

    private static float getRandomLevel(float baseLevel, Random rand) {
        return (LootSelector.getRandomLevel2(baseLevel - 0.6f, rand) + LootSelector.getRandomLevel2(baseLevel + 0.5f, rand)) / 2.0f - 0.5f;
    }

    private static float getRandomLevel2(float baseLevel, Random rand) {
        float result = baseLevel + rand.nextFloat() * (4.0f - baseLevel) / 3.0f;
        for (int i = 1; i < 2; ++i) {
            if (!((result += rand.nextFloat() / (float)i * 2.0f) >= baseLevel + 1.0f)) continue;
            result -= rand.nextFloat() / (float)(i + 1);
        }
        return Math.min(result, 4.75f);
    }

    private Upgrade getUpgrade(Random rand) {
        return Upgrade.values()[rand.nextInt(Upgrade.values().length)];
    }

    static void test_getRandomLevel(float baselevel) {
        Random rand = new Random();
        int runs = 100000;
        int[] a = new int[50];
        for (int i = 0; i < runs; ++i) {
            int idx;
            float randomLevel = LootSelector.getRandomLevel(baselevel, rand);
            int n = idx = (int)(randomLevel * 10.0f);
            a[n] = a[n] + 1;
        }
        int max = 0;
        for (int j = 0; j < 50; ++j) {
            if (a[j] < max) continue;
            max = a[j];
        }
        for (int i = max; i > 0; i -= max / 20) {
            for (int j = 0; j < 50; ++j) {
                if (a[j] >= i) {
                    System.out.print("#");
                    continue;
                }
                System.out.print(" ");
            }
            System.out.println();
        }
        System.out.println("0....|...1.0...|...2.0...|...3.0...|...4.0...|...5.0");
    }

    public static class Serializer
    extends LootFunction.Serializer<LootSelector> {
        public Serializer() {
            super(new ResourceLocation("set_capacitor"), LootSelector.class);
        }

        public void serialize(JsonObject object, LootSelector functionClazz, JsonSerializationContext serializationContext) {
        }

        public LootSelector deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new LootSelector(conditionsIn);
        }
    }

    private static enum Upgrade {
        SMELTING(CapacitorHelper.SetType.NAME, CapacitorKey.ALLOY_SMELTER_POWER_USE, "smelting"),
        INTAKE(CapacitorHelper.SetType.TYPE, CapacitorKey.ALLOY_SMELTER_POWER_INTAKE, "intake"),
        BUFFER(CapacitorHelper.SetType.TYPE, CapacitorKey.ALLOY_SMELTER_POWER_BUFFER, "buffer"),
        CRAFTING(CapacitorHelper.SetType.NAME, CapacitorKey.CRAFTER_TICKS, "crafting"),
        AREA(CapacitorHelper.SetType.TYPE, CapacitorKey.ATTRACTOR_RANGE, "area"),
        GREEN(CapacitorHelper.SetType.NAME, CapacitorKey.FARM_BONUS_SIZE, "green"),
        RED(CapacitorHelper.SetType.NAME, CapacitorKey.STIRLING_POWER_GEN, "red");

        final CapacitorHelper.SetType setType;
        final CapacitorKey capacitorKey;
        final String langKey;

        private Upgrade(CapacitorHelper.SetType setType, CapacitorKey capacitorKey, String langKey) {
            this.setType = setType;
            this.capacitorKey = capacitorKey;
            this.langKey = "loot.capacitor." + langKey;
        }
    }
}

