/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.capability.ItemTools;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jline.internal.Log;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class NetworkedInventory {
    IItemConduit con;
    EnumFacing conDir;
    BlockCoord location;
    EnumFacing inventorySide;
    List<Target> sendPriority = new ArrayList<Target>();
    RoundRobinIterator<Target> rrIter = new RoundRobinIterator(this.sendPriority);
    private int extractFromSlot = -1;
    int tickDeficit;
    boolean inventoryPanel = false;
    World world;
    ItemConduitNetwork network;
    String invName;

    NetworkedInventory(ItemConduitNetwork network, IItemConduit con, EnumFacing conDir, IItemHandler inv, BlockCoord location) {
        this.network = network;
        this.inventorySide = conDir.func_176734_d();
        this.con = con;
        this.conDir = conDir;
        this.location = location;
        this.world = con.getBundle().getBundleWorldObj();
        IBlockState bs = this.world.func_180495_p(location.getBlockPos());
        this.invName = bs.func_177230_c().func_149732_F();
        TileEntity te = this.world.func_175625_s(location.getBlockPos());
        if (te instanceof TileInventoryPanel) {
            this.inventoryPanel = true;
        }
    }

    public boolean hasTarget(IItemConduit conduit, EnumFacing dir) {
        for (Target t : this.sendPriority) {
            if (t.inv.con != conduit || t.inv.conDir != dir) continue;
            return true;
        }
        return false;
    }

    boolean canExtract() {
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.INPUT || mode == ConnectionMode.IN_OUT;
    }

    boolean canInsert() {
        if (this.inventoryPanel) {
            return false;
        }
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.OUTPUT || mode == ConnectionMode.IN_OUT;
    }

    boolean isInventoryPanel() {
        return this.inventoryPanel;
    }

    boolean isSticky() {
        return this.con.getOutputFilter(this.conDir) != null && this.con.getOutputFilter(this.conDir).isValid() && this.con.getOutputFilter(this.conDir).isSticky();
    }

    int getPriority() {
        return this.con.getOutputPriority(this.conDir);
    }

    public void onTick() {
        if (this.tickDeficit <= 0 && this.canExtract() && this.con.isExtractionRedstoneConditionMet(this.conDir)) {
            this.transferItems();
        }
        --this.tickDeficit;
        if (this.tickDeficit < -1) {
            this.tickDeficit = 20;
        }
    }

    private int nextSlot(int numSlots) {
        ++this.extractFromSlot;
        if (this.extractFromSlot >= numSlots || this.extractFromSlot < 0) {
            this.extractFromSlot = 0;
        }
        return this.extractFromSlot;
    }

    private void setNextStartingSlot(int slot) {
        this.extractFromSlot = slot;
        --this.extractFromSlot;
    }

    private boolean transferItems() {
        IItemHandler inventory = this.getInventory();
        if (inventory == null) {
            return false;
        }
        int numSlots = inventory.getSlots();
        if (numSlots < 1) {
            return false;
        }
        ItemStack extractItem = null;
        int maxExtracted = this.con.getMaximumExtracted(this.conDir);
        int slot = -1;
        int slotChecksPerTick = Math.min(numSlots, ItemConduitNetwork.MAX_SLOT_CHECK_PER_TICK);
        for (int i = 0; i < slotChecksPerTick; ++i) {
            slot = this.nextSlot(numSlots);
            ItemStack item = inventory.getStackInSlot(slot);
            if (!this.canExtractItem(item)) continue;
            extractItem = item.func_77946_l();
            if (inventory.extractItem(slot, extractItem.field_77994_a, true) == null || !this.doTransfer(extractItem, slot, maxExtracted)) continue;
            this.setNextStartingSlot(slot);
            return true;
        }
        return false;
    }

    private boolean canExtractItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        IItemFilter filter = this.con.getInputFilter(this.conDir);
        if (filter == null) {
            return true;
        }
        return filter.doesItemPassFilter(this, itemStack);
    }

    private boolean doTransfer(ItemStack extractedItem, int slot, int maxExtract) {
        if (extractedItem == null || extractedItem.func_77973_b() == null) {
            return false;
        }
        ItemStack toExtract = extractedItem.func_77946_l();
        toExtract.field_77994_a = Math.min(maxExtract, toExtract.field_77994_a);
        int numInserted = this.insertIntoTargets(toExtract);
        if (numInserted <= 0) {
            return false;
        }
        this.itemExtracted(slot, numInserted);
        return true;
    }

    public void itemExtracted(int slot, int numInserted) {
        ItemStack extracted;
        ItemStack curStack;
        IItemHandler inventory = this.getInventory();
        if (inventory != null && (curStack = inventory.getStackInSlot(slot)) != null && ((extracted = inventory.extractItem(slot, numInserted, false)) == null || extracted.field_77994_a != numInserted)) {
            Log.warn((Object[])new Object[]{"NetworkedInventory.itemExtracted: Inserted " + numInserted + " " + curStack.func_82833_r() + " but only removed " + (extracted == null ? "null" : Integer.valueOf(extracted.field_77994_a))});
        }
        this.con.itemsExtracted(numInserted, slot);
        this.tickDeficit = Math.round((float)numInserted * this.con.getTickTimePerItem(this.conDir));
    }

    int insertIntoTargets(ItemStack toExtract) {
        int totalToInsert;
        if (toExtract == null) {
            return 0;
        }
        int leftToInsert = totalToInsert = toExtract.field_77994_a;
        boolean matchedStickyInput = false;
        Iterable<Target> targets = this.getTargetIterator();
        for (Target target : targets) {
            if (target.stickyInput && !matchedStickyInput) {
                IItemFilter of = target.inv.con.getOutputFilter(target.inv.conDir);
                boolean bl = matchedStickyInput = of != null && of.isValid() && of.doesItemPassFilter(this, toExtract);
            }
            if (!target.stickyInput && matchedStickyInput) continue;
            int inserted = target.inv.insertItem(toExtract);
            if (inserted > 0) {
                toExtract.field_77994_a -= inserted;
                leftToInsert -= inserted;
            }
            if (leftToInsert > 0) continue;
            return totalToInsert;
        }
        return totalToInsert - leftToInsert;
    }

    private Iterable<Target> getTargetIterator() {
        if (this.con.isRoundRobinEnabled(this.conDir)) {
            return this.rrIter;
        }
        return this.sendPriority;
    }

    private int insertItem(ItemStack item) {
        if (!this.canInsert() || item == null) {
            return 0;
        }
        IItemFilter filter = this.con.getOutputFilter(this.conDir);
        if (filter != null && !filter.doesItemPassFilter(this, item)) {
            return 0;
        }
        return ItemTools.doInsertItem(this.getInventory(), item);
    }

    void updateInsertOrder() {
        this.sendPriority.clear();
        if (!this.canExtract()) {
            return;
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (NetworkedInventory other : this.network.inventories) {
            if (!this.con.isSelfFeedEnabled(this.conDir) && other == this || !other.canInsert() || this.con.getInputColor(this.conDir) != other.con.getOutputColor(other.conDir)) continue;
            if (Config.itemConduitUsePhyscialDistance) {
                this.sendPriority.add(new Target(other, this.distanceTo(other), other.isSticky(), other.getPriority()));
                continue;
            }
            result.add(new Target(other, 9999999, other.isSticky(), other.getPriority()));
        }
        if (Config.itemConduitUsePhyscialDistance) {
            Collections.sort(this.sendPriority);
        } else if (!result.isEmpty()) {
            HashMap<BlockCoord, Integer> visited = new HashMap<BlockCoord, Integer>();
            ArrayList<BlockCoord> steps = new ArrayList<BlockCoord>();
            steps.add(this.con.getLocation());
            this.calculateDistances(result, visited, steps, 0);
            this.sendPriority.addAll(result);
            Collections.sort(this.sendPriority);
        }
    }

    private void calculateDistances(List<Target> targets, Map<BlockCoord, Integer> visited, List<BlockCoord> steps, int distance) {
        if (steps == null || steps.isEmpty()) {
            return;
        }
        ArrayList<BlockCoord> nextSteps = new ArrayList<BlockCoord>();
        for (BlockCoord bc : steps) {
            IItemConduit con1 = this.network.conMap.get(bc);
            if (con1 == null) continue;
            for (EnumFacing dir : con1.getExternalConnections()) {
                Target target = this.getTarget(targets, con1, dir);
                if (target == null || target.distance <= distance) continue;
                target.distance = distance;
            }
            if (!visited.containsKey(bc)) {
                visited.put(bc, distance);
            } else {
                int prevDist = visited.get(bc);
                if (prevDist <= distance) continue;
                visited.put(bc, distance);
            }
            for (EnumFacing dir : con1.getConduitConnections()) {
                nextSteps.add(bc.getLocation(dir));
            }
        }
        this.calculateDistances(targets, visited, nextSteps, distance + 1);
    }

    private Target getTarget(List<Target> targets, IItemConduit con1, EnumFacing dir) {
        if (targets == null || con1 == null || con1.getLocation() == null) {
            return null;
        }
        for (Target target : targets) {
            BlockCoord targetConLoc = null;
            if (target == null || target.inv == null || target.inv.con == null || (targetConLoc = target.inv.con.getLocation()) == null || target.inv.conDir != dir || !targetConLoc.equals((Object)con1.getLocation())) continue;
            return target;
        }
        return null;
    }

    private int distanceTo(NetworkedInventory other) {
        return this.con.getLocation().getDistSq(other.con.getLocation());
    }

    @Nullable
    public IItemHandler getInventory() {
        return ItemTools.getExternalInventory((IBlockAccess)this.world, this.location.getBlockPos(), this.inventorySide);
    }

    public EnumFacing getInventorySide() {
        return this.inventorySide;
    }

    public void setInventorySide(EnumFacing inventorySide) {
        this.inventorySide = inventorySide;
    }

    public String getLocalizedInventoryName() {
        return this.invName;
    }

    static class Target
    implements Comparable<Target> {
        NetworkedInventory inv;
        int distance;
        boolean stickyInput;
        int priority;

        Target(NetworkedInventory inv, int distance, boolean stickyInput, int priority) {
            this.inv = inv;
            this.distance = distance;
            this.stickyInput = stickyInput;
            this.priority = priority;
        }

        @Override
        public int compareTo(Target o) {
            if (this.stickyInput && !o.stickyInput) {
                return -1;
            }
            if (!this.stickyInput && o.stickyInput) {
                return 1;
            }
            if (this.priority != o.priority) {
                return ItemConduitNetwork.compare(o.priority, this.priority);
            }
            return ItemConduitNetwork.compare(this.distance, o.distance);
        }
    }
}

