/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConnectionModeGeometry;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.render.BakedQuadBuilder;
import crazypants.enderio.conduit.render.ConduitBundleRenderManager;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedLiquidConduitRenderer
extends DefaultConduitRenderer {
    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof AdvancedLiquidConduit;
    }

    @Override
    protected void addConduitQuads(IConduitBundle bundle, IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
        super.addConduitQuads(bundle, conduit, tex, component, selfIllum, quads);
        if (!this.isNSEWUD(component.dir)) {
            return;
        }
        AdvancedLiquidConduit lc = (AdvancedLiquidConduit)conduit;
        for (EnumFacing dir : conduit.getExternalConnections()) {
            TextureAtlasSprite ioTex = null;
            if (conduit.getConnectionMode(dir) == ConnectionMode.INPUT) {
                ioTex = lc.getTextureForInputMode();
            } else if (conduit.getConnectionMode(dir) == ConnectionMode.OUTPUT) {
                ioTex = lc.getTextureForOutputMode();
            }
            if (ioTex == null) continue;
            Offset offset = bundle.getOffset(ILiquidConduit.class, dir);
            ConnectionModeGeometry.addModeConnectorQuads(dir, offset, ioTex, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), quads);
        }
        FluidStack fluid = lc.getFluidType();
        TextureAtlasSprite texture = RenderUtil.getStillTexture((FluidStack)fluid);
        if (texture == null) {
            texture = lc.getNotSetEdgeTexture();
        }
        float scaleFactor = 0.75f;
        float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 1.0f : scaleFactor;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (d == component.dir || d == component.dir.func_176734_d()) continue;
            EnumFacing vDir = RenderUtil.getVDirForFace((EnumFacing)d);
            if (component.dir == EnumFacing.UP || component.dir == EnumFacing.DOWN) {
                vDir = RenderUtil.getUDirForFace((EnumFacing)d);
            } else if ((component.dir == EnumFacing.NORTH || component.dir == EnumFacing.SOUTH) && d.func_96559_d() != 0) {
                vDir = RenderUtil.getUDirForFace((EnumFacing)d);
            }
            float minU = texture.func_94209_e();
            float maxU = texture.func_94212_f();
            float minV = texture.func_94206_g();
            float maxV = texture.func_94210_h();
            double sideScale = Math.max(bb.sizeX(), bb.sizeY()) * 2.0 / 16.0;
            sideScale = Math.max(sideScale, bb.sizeZ() * 2.0 / 16.0);
            double width = Math.min(bb.sizeX(), bb.sizeY()) * 15.0 / 16.0;
            List corners = bb.getCornersWithUvForFace(d, minU, maxU, minV, maxV);
            this.moveEdgeCorners(corners, vDir, width);
            this.moveEdgeCorners(corners, component.dir.func_176734_d(), sideScale);
            for (Vertex c : corners) {
                vertices.add(c);
            }
            corners = bb.getCornersWithUvForFace(d, minU, maxU, minV, maxV);
            this.moveEdgeCorners(corners, vDir.func_176734_d(), width);
            this.moveEdgeCorners(corners, component.dir.func_176734_d(), sideScale);
            for (Vertex c : corners) {
                vertices.add(c);
            }
        }
        if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
            tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
            List corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
            for (Vertex c : corners) {
                vertices.add(c);
            }
            for (int i = corners.size() - 1; i >= 0; --i) {
                Vertex c = (Vertex)corners.get(i);
                vertices.add(c);
            }
        }
        BakedQuadBuilder.addBakedQuads(quads, vertices, texture, null);
    }

    private void moveEdgeCorners(List<Vertex> vertices, EnumFacing edge, double scaleFactor) {
        int[] indices = this.getClosest(edge, vertices);
        vertices.get((int)indices[0]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[1]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[0]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[1]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[0]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
        vertices.get((int)indices[1]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
    }

    private int[] getClosest(EnumFacing edge, List<Vertex> vertices) {
        int[] res = new int[]{-1, -1};
        boolean highest = edge.func_82601_c() > 0 || edge.func_96559_d() > 0 || edge.func_82599_e() > 0;
        double minMax = highest ? -1.7976931348623157E308 : Double.MAX_VALUE;
        int index = 0;
        for (Vertex v : vertices) {
            double val = this.get(v.xyz, edge);
            if (highest ? val >= minMax : val <= minMax) {
                if (val != minMax) {
                    res[0] = index;
                } else {
                    res[1] = index;
                }
                minMax = val;
            }
            ++index;
        }
        return res;
    }

    private double get(Vector3d xyz, EnumFacing edge) {
        if (edge == EnumFacing.EAST || edge == EnumFacing.WEST) {
            return xyz.x;
        }
        if (edge == EnumFacing.UP || edge == EnumFacing.DOWN) {
            return xyz.y;
        }
        return xyz.z;
    }
}

