/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RedstoneConduit
extends AbstractConduit
implements IRedstoneConduit {
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    protected RedstoneConduitNetwork network;
    protected final List<Set<Signal>> externalSignals = new ArrayList<Set<Signal>>();
    protected boolean neighbourDirty = true;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put("enderio:blocks/redstoneConduit", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneConduit")));
                ICONS.put("enderio:blocks/redstoneConduitTransmission", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneConduitTransmission")));
            }
        });
    }

    protected RedstoneConduit() {
        for (EnumFacing ignored : EnumFacing.field_82609_l) {
            this.externalSignals.add(new HashSet());
        }
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    public AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public void updateNetwork() {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world != null) {
            this.updateNetwork(world);
        }
    }

    @Override
    public void onChunkUnload(World worldObj) {
        RedstoneConduitNetwork network = (RedstoneConduitNetwork)this.getNetwork();
        if (network != null) {
            HashSet oldSignals = Sets.newHashSet(network.getSignals());
            ArrayList conduits = Lists.newArrayList(network.getConduits());
            super.onChunkUnload(worldObj);
            network.afterChunkUnload(conduits, oldSignals);
        }
    }

    protected boolean acceptSignalsForDir(EnumFacing dir) {
        BlockCoord loc = this.getLocation().getLocation(dir);
        return ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IRedstoneConduit.class) == null;
    }

    @Override
    public Set<Signal> getNetworkInputs() {
        return this.getNetworkInputs(null);
    }

    @Override
    public Set<Signal> getNetworkInputs(EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        HashSet<Signal> res = new HashSet<Signal>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (side != null && dir != side || !this.acceptSignalsForDir(dir)) continue;
            int input = this.getExternalPowerLevel(dir);
            if (input > 1) {
                BlockCoord loc = this.getLocation().getLocation(dir);
                Signal signal = new Signal(loc.x, loc.y, loc.z, dir, input - 1, this.getSignalColor(dir));
                res.add(signal);
            }
            if (!Loader.isModLoaded((String)"MineFactoryReloaded")) continue;
            res.addAll((Collection<Signal>)this.externalSignals.get(dir.ordinal()));
            int[] bundledInput = this.getExternalBundledPowerLevel(dir);
            if (bundledInput == null) continue;
            BlockCoord loc = this.getLocation().getLocation(dir);
            for (int subnet = 0; subnet < bundledInput.length; ++subnet) {
                if (bundledInput[subnet] <= 1) continue;
                int color = RedstoneConduit.convertColorForRedNet(subnet);
                Signal signal = new Signal(loc.x, loc.y, loc.z, dir, bundledInput[subnet] - 1, DyeColor.fromIndex((int)color));
                res.add(signal);
            }
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return res;
    }

    @Override
    public Set<Signal> getNetworkOutputs(EnumFacing side) {
        if (this.network == null) {
            return Collections.emptySet();
        }
        return this.network.getSignals();
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        this.neighbourDirty |= blockId != EnderIO.blockConduitBundle;
        return res;
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (!world.field_72995_K && this.neighbourDirty) {
            this.network.destroyNetwork();
            this.updateNetwork(world);
            this.neighbourDirty = false;
        }
    }

    protected int getExternalPowerLevel(EnumFacing dir) {
        World world = this.getBundle().getEntity().func_145831_w();
        BlockCoord loc = this.getLocation();
        int strong = world.func_175627_a((loc = loc.getLocation(dir)).getBlockPos(), dir);
        if (strong > 0) {
            return 16;
        }
        int res = world.func_175651_c(loc.getBlockPos(), dir);
        IBlockState bs = world.func_180495_p(loc.getBlockPos());
        Block block = bs.func_177230_c();
        if (res < 15 && block == Blocks.field_150488_af) {
            int wireIn = (Integer)bs.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            res = Math.max(res, wireIn);
        }
        return res;
    }

    protected int[] getExternalBundledPowerLevel(EnumFacing dir) {
        return null;
    }

    @Override
    public int isProvidingWeakPower(EnumFacing toDirection) {
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        for (Signal signal : this.getNetworkOutputs(toDirection.func_176734_d())) {
            result = Math.max(result, signal.strength);
        }
        return result;
    }

    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    public boolean onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbourPos) {
        return false;
    }

    private static int convertColorForRedNet(int colorOrSubnet) {
        return 15 - colorOrSubnet;
    }
}

