/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.Log;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeRoot;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.Alias;
import crazypants.enderio.config.recipes.xml.Recipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Recipes
implements RecipeRoot {
    private List<Alias> aliases;
    private List<Recipe> recipes;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.recipes != null || this.aliases != null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void register() {
        Log.debug("Starting registering XML recipes");
        if (this.recipes != null) {
            for (Recipe recipe : this.recipes) {
                recipe.register();
            }
        }
        Log.debug("Done registering XML recipes");
    }

    void initEmpty() {
        this.recipes = new ArrayList<Recipe>();
    }

    @Override
    public void addRecipes(RecipeRoot other) {
        if (other instanceof Recipes && ((Recipes)other).recipes != null) {
            if (this.recipes != null) {
                HashSet<String> recipeNames = new HashSet<String>();
                for (Recipe recipe : this.recipes) {
                    recipeNames.add(recipe.getName());
                }
                for (Recipe recipe : ((Recipes)other).recipes) {
                    if (recipeNames.contains(recipe.getName())) continue;
                    this.recipes.add(recipe);
                }
            } else {
                this.recipes = ((Recipes)other).recipes;
            }
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("enderio".equals(name)) {
            return true;
        }
        if ("xsi".equals(name)) {
            return true;
        }
        return "schemaLocation".equals(name);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("alias".equals(name)) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<Alias>();
            }
            this.aliases.add(factory.read(new Alias(), startElement));
            return true;
        }
        if ("recipe".equals(name)) {
            if (this.recipes == null) {
                this.recipes = new ArrayList<Recipe>();
            }
            this.recipes.add(factory.read(new Recipe(), startElement));
            return true;
        }
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.recipes != null) {
            for (Recipe recipe : this.recipes) {
                recipe.enforceValidity();
            }
        }
    }
}

