/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Matrix4d;
import crazypants.enderio.enderface.BlockEnderIO;
import crazypants.enderio.teleport.anchor.TravelEntitySpecialRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EnderIoRenderer
extends TileEntitySpecialRenderer<TileEntity> {
    private TravelEntitySpecialRenderer selectionRenderer = new TravelEntitySpecialRenderer(){

        @Override
        public TextureAtlasSprite getSelectedIcon() {
            return BlockEnderIO.selectedOverlayIcon.get(TextureAtlasSprite.class);
        }

        @Override
        public TextureAtlasSprite getHighlightIcon() {
            return BlockEnderIO.highlightOverlayIcon.get(TextureAtlasSprite.class);
        }
    };

    public void func_180535_a(TileEntity te, double x, double y, double z, float f, int breakingStage) {
        Matrix4d lookMat = null;
        int brightness = 255;
        if (te != null) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            lookMat = RenderUtil.createBillboardMatrix((TileEntity)te, (EntityLivingBase)entityPlayer);
        } else {
            lookMat = new Matrix4d();
            lookMat.setIdentity();
        }
        this.render(x, y, z, lookMat, brightness);
        if (te != null) {
            this.selectionRenderer.func_180535_a(te, x, y, z, f, breakingStage);
        }
    }

    public void render(double x, double y, double z, Matrix4d lookMat, int brightness) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        TextureAtlasSprite tex = BlockEnderIO.enderEyeTex.get(TextureAtlasSprite.class);
        float minU = tex.func_94209_e();
        float maxU = tex.func_94212_f();
        float minV = tex.func_94206_g();
        float maxV = tex.func_94210_h();
        RenderUtil.bindBlockTexture();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.renderBillboard((Matrix4d)lookMat, (float)minU, (float)maxU, (float)minV, (float)maxV, (double)0.8, (int)brightness);
        RenderUtil.bindGlintTexture();
        float maxUV = 32.0f;
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179145_e();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)768, (int)1);
        float blendFactor = 1.0f;
        GlStateManager.func_179131_c((float)(0.5f * blendFactor), (float)(0.25f * blendFactor), (float)(0.8f * blendFactor), (float)1.0f);
        GlStateManager.func_179128_n((int)5890);
        GL11.glPushMatrix();
        float scale = 0.125f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float tans = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
        GL11.glTranslatef((float)tans, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtil.renderBillboard((Matrix4d)lookMat, (float)0.0f, (float)maxUV, (float)0.0f, (float)maxUV, (double)0.8, (int)brightness);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        tans = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
        GL11.glTranslatef((float)(-tans), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtil.renderBillboard((Matrix4d)lookMat, (float)0.0f, (float)maxUV, (float)0.0f, (float)maxUV, (double)0.8, (int)brightness);
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

