/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.ChatUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.sound.IModSound;
import crazypants.enderio.sound.SoundHelper;
import crazypants.enderio.sound.SoundRegistry;
import crazypants.util.BaublesUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class KeyTracker {
    public static final KeyTracker instance = new KeyTracker();
    private final KeyBinding glideKey = new KeyBinding(EnderIO.lang.localize("keybind.glidertoggle"), 34, EnderIO.lang.localize("category.darksteelarmor"));
    private final KeyBinding soundDetectorKey;
    private final KeyBinding nightVisionKey;
    private final KeyBinding stepAssistKey;
    private final KeyBinding speedKey;
    private final KeyBinding jumpKey;
    private final KeyBinding gogglesKey;
    private final KeyBinding yetaWrenchMode;
    private final KeyBinding magnetKey;

    public KeyTracker() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.glideKey);
        this.soundDetectorKey = new KeyBinding(EnderIO.lang.localize("keybind.soundlocator"), 38, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.soundDetectorKey);
        this.nightVisionKey = new KeyBinding(EnderIO.lang.localize("keybind.nightvision"), 25, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.nightVisionKey);
        this.gogglesKey = new KeyBinding(EnderIO.lang.localize("keybind.gogglesofrevealing"), 19, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.gogglesKey);
        this.stepAssistKey = new KeyBinding(EnderIO.lang.localize("keybind.stepassist"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepAssistKey);
        this.speedKey = new KeyBinding(EnderIO.lang.localize("keybind.speed"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.speedKey);
        this.jumpKey = new KeyBinding(EnderIO.lang.localize("keybind.jump"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.jumpKey);
        this.yetaWrenchMode = new KeyBinding(EnderIO.lang.localize("keybind.yetawrenchmode"), 21, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.yetaWrenchMode);
        this.magnetKey = new KeyBinding(EnderIO.lang.localize("keybind.magnet"), 0, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.magnetKey);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.handleGlide();
        this.handleSoundDetector();
        this.handleNightVision();
        this.handleYetaWrench();
        this.handleGoggles();
        this.handleStepAssist();
        this.handleSpeed();
        this.handleJump();
        this.handleMagnet();
    }

    private void sendEnabledChatMessage(String messageBase, boolean isActive) {
        String message = messageBase.concat(isActive ? ".enabled" : ".disabled");
        ChatUtil.sendNoSpamClientUnloc((Lang)EnderIO.lang, (String[])new String[]{message});
    }

    private void toggleDarkSteelController(PacketUpgradeState.Type type, String messageBase) {
        boolean isActive = !DarkSteelController.instance.isActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type);
        this.sendEnabledChatMessage(messageBase, isActive);
        DarkSteelController.instance.setActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, isActive);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(type, isActive));
    }

    private void handleMagnet() {
        if (this.magnetKey.func_151468_f()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < 9; ++i) {
                if (inv[i] == null || inv[i].func_77973_b() == null || inv[i].func_77973_b() != DarkSteelItems.itemMagnet) continue;
                boolean isActive = !ItemMagnet.isActive(inv[i]);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, i, isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stack = baubles.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != DarkSteelItems.itemMagnet) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    private void handleJump() {
        if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.jumpKey.func_151468_f()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.JUMP, "darksteel.upgrade.jump");
        }
    }

    private void handleSpeed() {
        if (!SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.speedKey.func_151468_f()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.SPEED, "darksteel.upgrade.speed");
        }
    }

    private void handleStepAssist() {
        if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.stepAssistKey.func_151468_f()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.STEP_ASSIST, "darksteel.upgrade.stepAssist");
        }
    }

    private void handleGoggles() {
        if (this.gogglesKey.func_151468_f()) {
            boolean isActive = !DarkSteelItems.itemDarkSteelHelmet.isGogglesUgradeActive();
            this.sendEnabledChatMessage("darksteel.upgrade.goggles", isActive);
            DarkSteelItems.itemDarkSteelHelmet.setGogglesUgradeActive(isActive);
        }
    }

    private void handleYetaWrench() {
        if (!this.yetaWrenchMode.func_151468_f()) {
            if (this.yetaWrenchMode.func_151463_i() == 0) {
                Config.checkYetaAccess();
            }
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack equipped = player.func_184614_ca();
        if (equipped == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof IConduitControl) {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
            if (curMode == null) {
                curMode = ConduitDisplayMode.ALL;
            }
            ConduitDisplayMode newMode = player.func_70093_af() ? curMode.previous() : curMode.next();
            ConduitDisplayMode.setDisplayMode(equipped, newMode);
            PacketHandler.INSTANCE.sendToServer((IMessage)new YetaWrenchPacketProcessor(player.field_71071_by.field_70461_c, newMode));
        } else if (equipped.func_77973_b() == EnderIO.itemConduitProbe) {
            int newMeta = equipped.func_77952_i() == 0 ? 1 : 0;
            equipped.func_77964_b(newMeta);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    private void handleSoundDetector() {
        if (!this.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
            SoundDetector.instance.setEnabled(false);
            return;
        }
        if (this.soundDetectorKey.func_151468_f()) {
            boolean isActive = !SoundDetector.instance.isEnabled();
            this.sendEnabledChatMessage("darksteel.upgrade.sound", isActive);
            SoundDetector.instance.setEnabled(isActive);
        }
    }

    private void handleGlide() {
        if (!DarkSteelController.instance.isGliderUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        if (this.glideKey.func_151468_f()) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.GLIDE, "darksteel.upgrade.glider");
        }
    }

    private void handleNightVision() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!DarkSteelController.instance.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
            return;
        }
        if (this.nightVisionKey.func_151468_f()) {
            boolean isActive;
            boolean bl = isActive = !DarkSteelController.instance.isNightVisionActive();
            if (isActive) {
                SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_ON, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f);
            } else {
                SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_OFF, 0.1f, 1.0f);
            }
            DarkSteelController.instance.setNightVisionActive(isActive);
        }
    }

    public boolean isSoundDetectorUpgradeEquipped(EntityPlayerSP player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        SoundDetectorUpgrade upgrade = SoundDetectorUpgrade.loadFromItem(helmet);
        return upgrade != null;
    }

    public KeyBinding getYetaWrenchMode() {
        return this.yetaWrenchMode;
    }
}

