/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.jei.BaseRecipeHandler;
import crazypants.enderio.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.IGuiIngredient;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EnchanterRecipeCategory
extends BlankRecipeCategory {
    @Nonnull
    public static final String UID = "Enchanter";
    private int xOff = 15;
    private int yOff = 24;
    @Nonnull
    private final IDrawable background;
    private EnchanterRecipeWrapper currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<EnchanterRecipeWrapper>(EnchanterRecipeWrapper.class, UID){

            @Override
            public boolean isRecipeValid(@Nonnull EnchanterRecipeWrapper recipe) {
                return recipe.isValid();
            }
        }});
        registry.addRecipeClickArea(GuiEnchanter.class, 155, 8, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockEnchanter), new String[]{UID});
        ArrayList<EnchanterRecipeWrapper> result = new ArrayList<EnchanterRecipeWrapper>();
        for (EnchanterRecipe rec : EnchanterRecipeManager.getInstance().getRecipes()) {
            result.add(new EnchanterRecipeWrapper(rec));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerEnchanter.class, UID, ContainerEnchanter.FIRST_RECIPE_SLOT, ContainerEnchanter.NUM_RECIPE_SLOT, ContainerEnchanter.FIRST_INVENTORY_SLOT, ContainerEnchanter.NUM_INVENTORY_SLOT);
    }

    public EnchanterRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("enchanter");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 146, 48);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return EnderIO.blockEnchanter.func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        if (!(recipeWrapper instanceof EnchanterRecipeWrapper)) {
            this.currentRecipe = null;
            return;
        }
        this.currentRecipe = (EnchanterRecipeWrapper)recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        Map ings = guiItemStacks.getGuiIngredients();
        this.currentRecipe.setInfoData(ings);
        guiItemStacks.init(0, true, 16 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(1, true, 65 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(2, true, 85 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.init(3, false, 144 - this.xOff - 1, 34 - this.yOff);
        guiItemStacks.setFromRecipe(0, (Object)new ItemStack(Items.field_151099_bA));
        EnchanterRecipe rec = this.currentRecipe.rec;
        ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> lapizInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        EnchanterRecipeCategory.getItemStacks(rec, itemInputs, lapizInputs, itemOutputs);
        guiItemStacks.set(1, itemInputs);
        guiItemStacks.set(2, lapizInputs);
        guiItemStacks.set(3, itemOutputs);
    }

    private static void getItemStacks(EnchanterRecipe rec, List<ItemStack> itemInputs, List<ItemStack> lapizInputs, List<ItemStack> itemOutputs) {
        ItemStack item = rec.getInput().getInput();
        for (int level = 1; level <= rec.getEnchantment().func_77325_b(); ++level) {
            itemInputs.add(new ItemStack(item.func_77973_b(), level * rec.getItemsPerLevel(), item.func_77960_j()));
            lapizInputs.add(new ItemStack(Blocks.field_150368_y, rec.getLapizForStackSize(level * rec.getItemsPerLevel())));
            EnchantmentData enchantment = new EnchantmentData(rec.getEnchantment(), level);
            ItemStack output = new ItemStack((Item)Items.field_151134_bR);
            Items.field_151134_bR.func_92115_a(output, enchantment);
            itemOutputs.add(output);
        }
    }

    public static class EnchanterRecipeWrapper
    extends BlankRecipeWrapper {
        private final EnchanterRecipe rec;
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients;

        public EnchanterRecipeWrapper(EnchanterRecipe rec) {
            this.rec = rec;
        }

        public boolean isValid() {
            return this.rec != null && this.rec.isValid();
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.currentIngredients == null) {
                return;
            }
            ItemStack stack = null;
            IGuiIngredient<ItemStack> ging = this.currentIngredients.get(1);
            if (ging instanceof GuiIngredient) {
                GuiIngredient gi = (GuiIngredient)ging;
                stack = (ItemStack)gi.getIngredient();
            }
            if (stack == null) {
                return;
            }
            int level = this.rec.getLevelForStackSize(stack.field_77994_a);
            int cost = TileEnchanter.getEnchantmentCost(this.rec, level);
            String str = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{cost});
            minecraft.field_71466_p.func_78276_b(str, 6, 36, 8453920);
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
            this.currentIngredients = ings;
        }

        @Nonnull
        public List<?> getInputs() {
            ArrayList<Object> itemInputs = new ArrayList<Object>();
            ArrayList lapizInputs = new ArrayList();
            ArrayList itemOutputs = new ArrayList();
            EnchanterRecipeCategory.getItemStacks(this.rec, itemInputs, lapizInputs, itemOutputs);
            itemInputs.add(new ItemStack(Items.field_151099_bA));
            itemInputs.addAll(lapizInputs);
            return itemInputs;
        }

        @Nonnull
        public List<?> getOutputs() {
            ArrayList itemInputs = new ArrayList();
            ArrayList lapizInputs = new ArrayList();
            ArrayList itemOutputs = new ArrayList();
            EnchanterRecipeCategory.getItemStacks(this.rec, itemInputs, lapizInputs, itemOutputs);
            return itemOutputs;
        }
    }
}

